package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{MetricName, Namespace}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MetricStreamStatisticsMetric(
    namespace: Namespace,
    metricName: MetricName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric = {
    import MetricStreamStatisticsMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric
      .builder()
      .namespace(Namespace.unwrap(namespace): java.lang.String)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly =
    zio.aws.cloudwatch.model.MetricStreamStatisticsMetric.wrap(buildAwsValue())
}
object MetricStreamStatisticsMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MetricStreamStatisticsMetric =
      zio.aws.cloudwatch.model
        .MetricStreamStatisticsMetric(namespace, metricName)
    def namespace: Namespace
    def metricName: MetricName
    def getNamespace: ZIO[Any, Nothing, Namespace] = ZIO.succeed(namespace)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric
  ) extends zio.aws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly {
    override val namespace: Namespace =
      zio.aws.cloudwatch.model.primitives.Namespace(impl.namespace())
    override val metricName: MetricName =
      zio.aws.cloudwatch.model.primitives.MetricName(impl.metricName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric
  ): zio.aws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly =
    new Wrapper(impl)
}
