package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  ActionsEnabled,
  AlarmName,
  AlarmArn,
  SuppressorPeriod,
  AlarmDescription,
  AlarmRule,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class PutCompositeAlarmRequest(
    actionsEnabled: Optional[ActionsEnabled] = Optional.Absent,
    alarmActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    alarmDescription: Optional[AlarmDescription] = Optional.Absent,
    alarmName: AlarmName,
    alarmRule: AlarmRule,
    insufficientDataActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    okActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.cloudwatch.model.Tag]] = Optional.Absent,
    actionsSuppressor: Optional[AlarmArn] = Optional.Absent,
    actionsSuppressorWaitPeriod: Optional[SuppressorPeriod] = Optional.Absent,
    actionsSuppressorExtensionPeriod: Optional[SuppressorPeriod] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest = {
    import PutCompositeAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest
      .builder()
      .optionallyWith(
        actionsEnabled.map(value =>
          ActionsEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.actionsEnabled)
      .optionallyWith(
        alarmActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.alarmActions)
      .optionallyWith(
        alarmDescription.map(value =>
          AlarmDescription.unwrap(value): java.lang.String
        )
      )(_.alarmDescription)
      .alarmName(AlarmName.unwrap(alarmName): java.lang.String)
      .alarmRule(AlarmRule.unwrap(alarmRule): java.lang.String)
      .optionallyWith(
        insufficientDataActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.insufficientDataActions)
      .optionallyWith(
        okActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.okActions)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        actionsSuppressor.map(value => AlarmArn.unwrap(value): java.lang.String)
      )(_.actionsSuppressor)
      .optionallyWith(
        actionsSuppressorWaitPeriod.map(value =>
          SuppressorPeriod.unwrap(value): Integer
        )
      )(_.actionsSuppressorWaitPeriod)
      .optionallyWith(
        actionsSuppressorExtensionPeriod.map(value =>
          SuppressorPeriod.unwrap(value): Integer
        )
      )(_.actionsSuppressorExtensionPeriod)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.PutCompositeAlarmRequest.ReadOnly =
    zio.aws.cloudwatch.model.PutCompositeAlarmRequest.wrap(buildAwsValue())
}
object PutCompositeAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutCompositeAlarmRequest =
      zio.aws.cloudwatch.model.PutCompositeAlarmRequest(
        actionsEnabled.map(value => value),
        alarmActions.map(value => value),
        alarmDescription.map(value => value),
        alarmName,
        alarmRule,
        insufficientDataActions.map(value => value),
        okActions.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actionsSuppressor.map(value => value),
        actionsSuppressorWaitPeriod.map(value => value),
        actionsSuppressorExtensionPeriod.map(value => value)
      )
    def actionsEnabled: Optional[ActionsEnabled]
    def alarmActions: Optional[List[ResourceName]]
    def alarmDescription: Optional[AlarmDescription]
    def alarmName: AlarmName
    def alarmRule: AlarmRule
    def insufficientDataActions: Optional[List[ResourceName]]
    def okActions: Optional[List[ResourceName]]
    def tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]]
    def actionsSuppressor: Optional[AlarmArn]
    def actionsSuppressorWaitPeriod: Optional[SuppressorPeriod]
    def actionsSuppressorExtensionPeriod: Optional[SuppressorPeriod]
    def getActionsEnabled: ZIO[Any, AwsError, ActionsEnabled] =
      AwsError.unwrapOptionField("actionsEnabled", actionsEnabled)
    def getAlarmActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("alarmActions", alarmActions)
    def getAlarmDescription: ZIO[Any, AwsError, AlarmDescription] =
      AwsError.unwrapOptionField("alarmDescription", alarmDescription)
    def getAlarmName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(alarmName)
    def getAlarmRule: ZIO[Any, Nothing, AlarmRule] = ZIO.succeed(alarmRule)
    def getInsufficientDataActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField(
        "insufficientDataActions",
        insufficientDataActions
      )
    def getOkActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("okActions", okActions)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getActionsSuppressor: ZIO[Any, AwsError, AlarmArn] =
      AwsError.unwrapOptionField("actionsSuppressor", actionsSuppressor)
    def getActionsSuppressorWaitPeriod: ZIO[Any, AwsError, SuppressorPeriod] =
      AwsError.unwrapOptionField(
        "actionsSuppressorWaitPeriod",
        actionsSuppressorWaitPeriod
      )
    def getActionsSuppressorExtensionPeriod
        : ZIO[Any, AwsError, SuppressorPeriod] = AwsError.unwrapOptionField(
      "actionsSuppressorExtensionPeriod",
      actionsSuppressorExtensionPeriod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest
  ) extends zio.aws.cloudwatch.model.PutCompositeAlarmRequest.ReadOnly {
    override val actionsEnabled: Optional[ActionsEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsEnabled())
        .map(value => zio.aws.cloudwatch.model.primitives.ActionsEnabled(value))
    override val alarmActions: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.ResourceName(item)
          }.toList
        )
    override val alarmDescription: Optional[AlarmDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmDescription())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.AlarmDescription(value)
        )
    override val alarmName: AlarmName =
      zio.aws.cloudwatch.model.primitives.AlarmName(impl.alarmName())
    override val alarmRule: AlarmRule =
      zio.aws.cloudwatch.model.primitives.AlarmRule(impl.alarmRule())
    override val insufficientDataActions: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insufficientDataActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.ResourceName(item)
          }.toList
        )
    override val okActions: Optional[List[ResourceName]] = zio.aws.core.internal
      .optionalFromNullable(impl.okActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.ResourceName(item)
        }.toList
      )
    override val tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
    override val actionsSuppressor: Optional[AlarmArn] = zio.aws.core.internal
      .optionalFromNullable(impl.actionsSuppressor())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmArn(value))
    override val actionsSuppressorWaitPeriod: Optional[SuppressorPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsSuppressorWaitPeriod())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.SuppressorPeriod(value)
        )
    override val actionsSuppressorExtensionPeriod: Optional[SuppressorPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsSuppressorExtensionPeriod())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.SuppressorPeriod(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest
  ): zio.aws.cloudwatch.model.PutCompositeAlarmRequest.ReadOnly = new Wrapper(
    impl
  )
}
