package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{DashboardBody, DashboardName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutDashboardRequest(
    dashboardName: DashboardName,
    dashboardBody: DashboardBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest = {
    import PutDashboardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest
      .builder()
      .dashboardName(DashboardName.unwrap(dashboardName): java.lang.String)
      .dashboardBody(DashboardBody.unwrap(dashboardBody): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.PutDashboardRequest.ReadOnly =
    zio.aws.cloudwatch.model.PutDashboardRequest.wrap(buildAwsValue())
}
object PutDashboardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutDashboardRequest =
      zio.aws.cloudwatch.model.PutDashboardRequest(dashboardName, dashboardBody)
    def dashboardName: DashboardName
    def dashboardBody: DashboardBody
    def getDashboardName: ZIO[Any, Nothing, DashboardName] =
      ZIO.succeed(dashboardName)
    def getDashboardBody: ZIO[Any, Nothing, DashboardBody] =
      ZIO.succeed(dashboardBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest
  ) extends zio.aws.cloudwatch.model.PutDashboardRequest.ReadOnly {
    override val dashboardName: DashboardName =
      zio.aws.cloudwatch.model.primitives.DashboardName(impl.dashboardName())
    override val dashboardBody: DashboardBody =
      zio.aws.cloudwatch.model.primitives.DashboardBody(impl.dashboardBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest
  ): zio.aws.cloudwatch.model.PutDashboardRequest.ReadOnly = new Wrapper(impl)
}
