package zio.aws.cloudwatch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutDashboardResponse(
    dashboardValidationMessages: Optional[
      Iterable[zio.aws.cloudwatch.model.DashboardValidationMessage]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse = {
    import PutDashboardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse
      .builder()
      .optionallyWith(
        dashboardValidationMessages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dashboardValidationMessages)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.PutDashboardResponse.ReadOnly =
    zio.aws.cloudwatch.model.PutDashboardResponse.wrap(buildAwsValue())
}
object PutDashboardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutDashboardResponse =
      zio.aws.cloudwatch.model.PutDashboardResponse(
        dashboardValidationMessages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dashboardValidationMessages: Optional[
      List[zio.aws.cloudwatch.model.DashboardValidationMessage.ReadOnly]
    ]
    def getDashboardValidationMessages: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.DashboardValidationMessage.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dashboardValidationMessages",
      dashboardValidationMessages
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse
  ) extends zio.aws.cloudwatch.model.PutDashboardResponse.ReadOnly {
    override val dashboardValidationMessages: Optional[
      List[zio.aws.cloudwatch.model.DashboardValidationMessage.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dashboardValidationMessages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.DashboardValidationMessage.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse
  ): zio.aws.cloudwatch.model.PutDashboardResponse.ReadOnly = new Wrapper(impl)
}
