package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  InsightRuleDefinition,
  InsightRuleState,
  InsightRuleName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutInsightRuleRequest(
    ruleName: InsightRuleName,
    ruleState: Optional[InsightRuleState] = Optional.Absent,
    ruleDefinition: InsightRuleDefinition,
    tags: Optional[Iterable[zio.aws.cloudwatch.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest = {
    import PutInsightRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest
      .builder()
      .ruleName(InsightRuleName.unwrap(ruleName): java.lang.String)
      .optionallyWith(
        ruleState.map(value => InsightRuleState.unwrap(value): java.lang.String)
      )(_.ruleState)
      .ruleDefinition(
        InsightRuleDefinition.unwrap(ruleDefinition): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.PutInsightRuleRequest.ReadOnly =
    zio.aws.cloudwatch.model.PutInsightRuleRequest.wrap(buildAwsValue())
}
object PutInsightRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutInsightRuleRequest =
      zio.aws.cloudwatch.model.PutInsightRuleRequest(
        ruleName,
        ruleState.map(value => value),
        ruleDefinition,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ruleName: InsightRuleName
    def ruleState: Optional[InsightRuleState]
    def ruleDefinition: InsightRuleDefinition
    def tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]]
    def getRuleName: ZIO[Any, Nothing, InsightRuleName] = ZIO.succeed(ruleName)
    def getRuleState: ZIO[Any, AwsError, InsightRuleState] =
      AwsError.unwrapOptionField("ruleState", ruleState)
    def getRuleDefinition: ZIO[Any, Nothing, InsightRuleDefinition] =
      ZIO.succeed(ruleDefinition)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest
  ) extends zio.aws.cloudwatch.model.PutInsightRuleRequest.ReadOnly {
    override val ruleName: InsightRuleName =
      zio.aws.cloudwatch.model.primitives.InsightRuleName(impl.ruleName())
    override val ruleState: Optional[InsightRuleState] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleState())
      .map(value => zio.aws.cloudwatch.model.primitives.InsightRuleState(value))
    override val ruleDefinition: InsightRuleDefinition =
      zio.aws.cloudwatch.model.primitives
        .InsightRuleDefinition(impl.ruleDefinition())
    override val tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest
  ): zio.aws.cloudwatch.model.PutInsightRuleRequest.ReadOnly = new Wrapper(impl)
}
