package zio.aws.cloudwatch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutManagedInsightRulesResponse(
    failures: Optional[Iterable[zio.aws.cloudwatch.model.PartialFailure]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse = {
    import PutManagedInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly =
    zio.aws.cloudwatch.model.PutManagedInsightRulesResponse
      .wrap(buildAwsValue())
}
object PutManagedInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutManagedInsightRulesResponse =
      zio.aws.cloudwatch.model.PutManagedInsightRulesResponse(
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failures
        : Optional[List[zio.aws.cloudwatch.model.PartialFailure.ReadOnly]]
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.PartialFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse
  ) extends zio.aws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly {
    override val failures
        : Optional[List[zio.aws.cloudwatch.model.PartialFailure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.PartialFailure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse
  ): zio.aws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly =
    new Wrapper(impl)
}
