package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  IncludeLinkedAccountsMetrics,
  AmazonResourceName,
  MetricStreamName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutMetricStreamRequest(
    name: MetricStreamName,
    includeFilters: Optional[
      Iterable[zio.aws.cloudwatch.model.MetricStreamFilter]
    ] = Optional.Absent,
    excludeFilters: Optional[
      Iterable[zio.aws.cloudwatch.model.MetricStreamFilter]
    ] = Optional.Absent,
    firehoseArn: AmazonResourceName,
    roleArn: AmazonResourceName,
    outputFormat: zio.aws.cloudwatch.model.MetricStreamOutputFormat,
    tags: Optional[Iterable[zio.aws.cloudwatch.model.Tag]] = Optional.Absent,
    statisticsConfigurations: Optional[
      Iterable[zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration]
    ] = Optional.Absent,
    includeLinkedAccountsMetrics: Optional[IncludeLinkedAccountsMetrics] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest = {
    import PutMetricStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest
      .builder()
      .name(MetricStreamName.unwrap(name): java.lang.String)
      .optionallyWith(
        includeFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includeFilters)
      .optionallyWith(
        excludeFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludeFilters)
      .firehoseArn(AmazonResourceName.unwrap(firehoseArn): java.lang.String)
      .roleArn(AmazonResourceName.unwrap(roleArn): java.lang.String)
      .outputFormat(outputFormat.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        statisticsConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statisticsConfigurations)
      .optionallyWith(
        includeLinkedAccountsMetrics.map(value =>
          IncludeLinkedAccountsMetrics.unwrap(value): java.lang.Boolean
        )
      )(_.includeLinkedAccountsMetrics)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.PutMetricStreamRequest.ReadOnly =
    zio.aws.cloudwatch.model.PutMetricStreamRequest.wrap(buildAwsValue())
}
object PutMetricStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutMetricStreamRequest =
      zio.aws.cloudwatch.model.PutMetricStreamRequest(
        name,
        includeFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        excludeFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firehoseArn,
        roleArn,
        outputFormat,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statisticsConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includeLinkedAccountsMetrics.map(value => value)
      )
    def name: MetricStreamName
    def includeFilters
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly]]
    def excludeFilters
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly]]
    def firehoseArn: AmazonResourceName
    def roleArn: AmazonResourceName
    def outputFormat: zio.aws.cloudwatch.model.MetricStreamOutputFormat
    def tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]]
    def statisticsConfigurations: Optional[List[
      zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]]
    def includeLinkedAccountsMetrics: Optional[IncludeLinkedAccountsMetrics]
    def getName: ZIO[Any, Nothing, MetricStreamName] = ZIO.succeed(name)
    def getIncludeFilters: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("includeFilters", includeFilters)
    def getExcludeFilters: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("excludeFilters", excludeFilters)
    def getFirehoseArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(firehoseArn)
    def getRoleArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(roleArn)
    def getOutputFormat
        : ZIO[Any, Nothing, zio.aws.cloudwatch.model.MetricStreamOutputFormat] =
      ZIO.succeed(outputFormat)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStatisticsConfigurations: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statisticsConfigurations",
      statisticsConfigurations
    )
    def getIncludeLinkedAccountsMetrics
        : ZIO[Any, AwsError, IncludeLinkedAccountsMetrics] =
      AwsError.unwrapOptionField(
        "includeLinkedAccountsMetrics",
        includeLinkedAccountsMetrics
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest
  ) extends zio.aws.cloudwatch.model.PutMetricStreamRequest.ReadOnly {
    override val name: MetricStreamName =
      zio.aws.cloudwatch.model.primitives.MetricStreamName(impl.name())
    override val includeFilters
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricStreamFilter.wrap(item)
          }.toList
        )
    override val excludeFilters
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricStreamFilter.wrap(item)
          }.toList
        )
    override val firehoseArn: AmazonResourceName =
      zio.aws.cloudwatch.model.primitives.AmazonResourceName(impl.firehoseArn())
    override val roleArn: AmazonResourceName =
      zio.aws.cloudwatch.model.primitives.AmazonResourceName(impl.roleArn())
    override val outputFormat
        : zio.aws.cloudwatch.model.MetricStreamOutputFormat =
      zio.aws.cloudwatch.model.MetricStreamOutputFormat
        .wrap(impl.outputFormat())
    override val tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
    override val statisticsConfigurations: Optional[List[
      zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.statisticsConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration
            .wrap(item)
        }.toList
      )
    override val includeLinkedAccountsMetrics
        : Optional[IncludeLinkedAccountsMetrics] = zio.aws.core.internal
      .optionalFromNullable(impl.includeLinkedAccountsMetrics())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.IncludeLinkedAccountsMetrics(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest
  ): zio.aws.cloudwatch.model.PutMetricStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
