package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutMetricStreamResponse(
    arn: Optional[AmazonResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse = {
    import PutMetricStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.PutMetricStreamResponse.ReadOnly =
    zio.aws.cloudwatch.model.PutMetricStreamResponse.wrap(buildAwsValue())
}
object PutMetricStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutMetricStreamResponse =
      zio.aws.cloudwatch.model.PutMetricStreamResponse(arn.map(value => value))
    def arn: Optional[AmazonResourceName]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse
  ) extends zio.aws.cloudwatch.model.PutMetricStreamResponse.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.AmazonResourceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse
  ): zio.aws.cloudwatch.model.PutMetricStreamResponse.ReadOnly = new Wrapper(
    impl
  )
}
