package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.MetricStreamName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartMetricStreamsRequest(names: Iterable[MetricStreamName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest = {
    import StartMetricStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest
      .builder()
      .names(names.map { item =>
        MetricStreamName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.StartMetricStreamsRequest.ReadOnly =
    zio.aws.cloudwatch.model.StartMetricStreamsRequest.wrap(buildAwsValue())
}
object StartMetricStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.StartMetricStreamsRequest =
      zio.aws.cloudwatch.model.StartMetricStreamsRequest(names)
    def names: List[MetricStreamName]
    def getNames: ZIO[Any, Nothing, List[MetricStreamName]] = ZIO.succeed(names)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest
  ) extends zio.aws.cloudwatch.model.StartMetricStreamsRequest.ReadOnly {
    override val names: List[MetricStreamName] = impl
      .names()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.MetricStreamName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest
  ): zio.aws.cloudwatch.model.StartMetricStreamsRequest.ReadOnly = new Wrapper(
    impl
  )
}
