package zio.aws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait Statistic {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.Statistic
}
object Statistic {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.Statistic
  ): zio.aws.cloudwatch.model.Statistic = value match {
    case software.amazon.awssdk.services.cloudwatch.model.Statistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.Statistic.SAMPLE_COUNT =>
      val r = SampleCount
      r
    case software.amazon.awssdk.services.cloudwatch.model.Statistic.AVERAGE =>
      val r = Average
      r
    case software.amazon.awssdk.services.cloudwatch.model.Statistic.SUM =>
      val r = Sum
      r
    case software.amazon.awssdk.services.cloudwatch.model.Statistic.MINIMUM =>
      val r = Minimum
      r
    case software.amazon.awssdk.services.cloudwatch.model.Statistic.MAXIMUM =>
      val r = Maximum
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudwatch.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.Statistic =
      software.amazon.awssdk.services.cloudwatch.model.Statistic.UNKNOWN_TO_SDK_VERSION
  }
  case object SampleCount extends zio.aws.cloudwatch.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.Statistic =
      software.amazon.awssdk.services.cloudwatch.model.Statistic.SAMPLE_COUNT
  }
  case object Average extends zio.aws.cloudwatch.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.Statistic =
      software.amazon.awssdk.services.cloudwatch.model.Statistic.AVERAGE
  }
  case object Sum extends zio.aws.cloudwatch.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.Statistic =
      software.amazon.awssdk.services.cloudwatch.model.Statistic.SUM
  }
  case object Minimum extends zio.aws.cloudwatch.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.Statistic =
      software.amazon.awssdk.services.cloudwatch.model.Statistic.MINIMUM
  }
  case object Maximum extends zio.aws.cloudwatch.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.Statistic =
      software.amazon.awssdk.services.cloudwatch.model.Statistic.MAXIMUM
  }
}
