package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.DatapointValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StatisticSet(
    sampleCount: DatapointValue,
    sum: DatapointValue,
    minimum: DatapointValue,
    maximum: DatapointValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.StatisticSet = {
    import StatisticSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.StatisticSet
      .builder()
      .sampleCount(DatapointValue.unwrap(sampleCount): java.lang.Double)
      .sum(DatapointValue.unwrap(sum): java.lang.Double)
      .minimum(DatapointValue.unwrap(minimum): java.lang.Double)
      .maximum(DatapointValue.unwrap(maximum): java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.StatisticSet.ReadOnly =
    zio.aws.cloudwatch.model.StatisticSet.wrap(buildAwsValue())
}
object StatisticSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.StatisticSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.StatisticSet =
      zio.aws.cloudwatch.model.StatisticSet(sampleCount, sum, minimum, maximum)
    def sampleCount: DatapointValue
    def sum: DatapointValue
    def minimum: DatapointValue
    def maximum: DatapointValue
    def getSampleCount: ZIO[Any, Nothing, DatapointValue] =
      ZIO.succeed(sampleCount)
    def getSum: ZIO[Any, Nothing, DatapointValue] = ZIO.succeed(sum)
    def getMinimum: ZIO[Any, Nothing, DatapointValue] = ZIO.succeed(minimum)
    def getMaximum: ZIO[Any, Nothing, DatapointValue] = ZIO.succeed(maximum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.StatisticSet
  ) extends zio.aws.cloudwatch.model.StatisticSet.ReadOnly {
    override val sampleCount: DatapointValue =
      zio.aws.cloudwatch.model.primitives.DatapointValue(impl.sampleCount())
    override val sum: DatapointValue =
      zio.aws.cloudwatch.model.primitives.DatapointValue(impl.sum())
    override val minimum: DatapointValue =
      zio.aws.cloudwatch.model.primitives.DatapointValue(impl.minimum())
    override val maximum: DatapointValue =
      zio.aws.cloudwatch.model.primitives.DatapointValue(impl.maximum())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.StatisticSet
  ): zio.aws.cloudwatch.model.StatisticSet.ReadOnly = new Wrapper(impl)
}
