package zio.aws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait StatusCode {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.StatusCode
}
object StatusCode {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.StatusCode
  ): zio.aws.cloudwatch.model.StatusCode = value match {
    case software.amazon.awssdk.services.cloudwatch.model.StatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.StatusCode.COMPLETE =>
      val r = Complete
      r
    case software.amazon.awssdk.services.cloudwatch.model.StatusCode.INTERNAL_ERROR =>
      val r = InternalError
      r
    case software.amazon.awssdk.services.cloudwatch.model.StatusCode.PARTIAL_DATA =>
      val r = PartialData
      r
    case software.amazon.awssdk.services.cloudwatch.model.StatusCode.FORBIDDEN =>
      val r = Forbidden
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudwatch.model.StatusCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StatusCode =
      software.amazon.awssdk.services.cloudwatch.model.StatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object Complete extends zio.aws.cloudwatch.model.StatusCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StatusCode =
      software.amazon.awssdk.services.cloudwatch.model.StatusCode.COMPLETE
  }
  case object InternalError extends zio.aws.cloudwatch.model.StatusCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StatusCode =
      software.amazon.awssdk.services.cloudwatch.model.StatusCode.INTERNAL_ERROR
  }
  case object PartialData extends zio.aws.cloudwatch.model.StatusCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StatusCode =
      software.amazon.awssdk.services.cloudwatch.model.StatusCode.PARTIAL_DATA
  }
  case object Forbidden extends zio.aws.cloudwatch.model.StatusCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StatusCode =
      software.amazon.awssdk.services.cloudwatch.model.StatusCode.FORBIDDEN
  }
}
