package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  WrapperInt,
  Timestamp,
  WrapperLong,
  NonEmptyString
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Build(
    id: Option[NonEmptyString] = None,
    arn: Option[NonEmptyString] = None,
    buildNumber: Option[WrapperLong] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    currentPhase: Option[String] = None,
    buildStatus: Option[zio.aws.codebuild.model.StatusType] = None,
    sourceVersion: Option[NonEmptyString] = None,
    resolvedSourceVersion: Option[NonEmptyString] = None,
    projectName: Option[NonEmptyString] = None,
    phases: Option[Iterable[zio.aws.codebuild.model.BuildPhase]] = None,
    source: Option[zio.aws.codebuild.model.ProjectSource] = None,
    secondarySources: Option[Iterable[zio.aws.codebuild.model.ProjectSource]] =
      None,
    secondarySourceVersions: Option[
      Iterable[zio.aws.codebuild.model.ProjectSourceVersion]
    ] = None,
    artifacts: Option[zio.aws.codebuild.model.BuildArtifacts] = None,
    secondaryArtifacts: Option[
      Iterable[zio.aws.codebuild.model.BuildArtifacts]
    ] = None,
    cache: Option[zio.aws.codebuild.model.ProjectCache] = None,
    environment: Option[zio.aws.codebuild.model.ProjectEnvironment] = None,
    serviceRole: Option[NonEmptyString] = None,
    logs: Option[zio.aws.codebuild.model.LogsLocation] = None,
    timeoutInMinutes: Option[WrapperInt] = None,
    queuedTimeoutInMinutes: Option[WrapperInt] = None,
    buildComplete: Option[Boolean] = None,
    initiator: Option[String] = None,
    vpcConfig: Option[zio.aws.codebuild.model.VpcConfig] = None,
    networkInterface: Option[zio.aws.codebuild.model.NetworkInterface] = None,
    encryptionKey: Option[NonEmptyString] = None,
    exportedEnvironmentVariables: Option[
      Iterable[zio.aws.codebuild.model.ExportedEnvironmentVariable]
    ] = None,
    reportArns: Option[Iterable[String]] = None,
    fileSystemLocations: Option[
      Iterable[zio.aws.codebuild.model.ProjectFileSystemLocation]
    ] = None,
    debugSession: Option[zio.aws.codebuild.model.DebugSession] = None,
    buildBatchArn: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.codebuild.model.Build = {
    import Build.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.Build
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        buildNumber.map(value => WrapperLong.unwrap(value): java.lang.Long)
      )(_.buildNumber)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(currentPhase.map(value => value: java.lang.String))(
        _.currentPhase
      )
      .optionallyWith(buildStatus.map(value => value.unwrap))(_.buildStatus)
      .optionallyWith(
        sourceVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .optionallyWith(
        resolvedSourceVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resolvedSourceVersion)
      .optionallyWith(
        projectName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        phases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phases)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        secondarySources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySources)
      .optionallyWith(
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourceVersions)
      .optionallyWith(artifacts.map(value => value.buildAwsValue()))(
        _.artifacts
      )
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .optionallyWith(cache.map(value => value.buildAwsValue()))(_.cache)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(logs.map(value => value.buildAwsValue()))(_.logs)
      .optionallyWith(
        timeoutInMinutes.map(value => WrapperInt.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .optionallyWith(
        queuedTimeoutInMinutes.map(value => WrapperInt.unwrap(value): Integer)
      )(_.queuedTimeoutInMinutes)
      .optionallyWith(buildComplete.map(value => value: java.lang.Boolean))(
        _.buildComplete
      )
      .optionallyWith(initiator.map(value => value: java.lang.String))(
        _.initiator
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(networkInterface.map(value => value.buildAwsValue()))(
        _.networkInterface
      )
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(
        exportedEnvironmentVariables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportedEnvironmentVariables)
      .optionallyWith(
        reportArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.reportArns)
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .optionallyWith(debugSession.map(value => value.buildAwsValue()))(
        _.debugSession
      )
      .optionallyWith(buildBatchArn.map(value => value: java.lang.String))(
        _.buildBatchArn
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.Build.ReadOnly =
    zio.aws.codebuild.model.Build.wrap(buildAwsValue())
}
object Build {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codebuild.model.Build] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.Build =
      zio.aws.codebuild.model.Build(
        id.map(value => value),
        arn.map(value => value),
        buildNumber.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        currentPhase.map(value => value),
        buildStatus.map(value => value),
        sourceVersion.map(value => value),
        resolvedSourceVersion.map(value => value),
        projectName.map(value => value),
        phases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        source.map(value => value.asEditable),
        secondarySources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        artifacts.map(value => value.asEditable),
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cache.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        serviceRole.map(value => value),
        logs.map(value => value.asEditable),
        timeoutInMinutes.map(value => value),
        queuedTimeoutInMinutes.map(value => value),
        buildComplete.map(value => value),
        initiator.map(value => value),
        vpcConfig.map(value => value.asEditable),
        networkInterface.map(value => value.asEditable),
        encryptionKey.map(value => value),
        exportedEnvironmentVariables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reportArns.map(value => value),
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        debugSession.map(value => value.asEditable),
        buildBatchArn.map(value => value)
      )
    def id: Option[NonEmptyString]
    def arn: Option[NonEmptyString]
    def buildNumber: Option[WrapperLong]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def currentPhase: Option[String]
    def buildStatus: Option[zio.aws.codebuild.model.StatusType]
    def sourceVersion: Option[NonEmptyString]
    def resolvedSourceVersion: Option[NonEmptyString]
    def projectName: Option[NonEmptyString]
    def phases: Option[List[zio.aws.codebuild.model.BuildPhase.ReadOnly]]
    def source: Option[zio.aws.codebuild.model.ProjectSource.ReadOnly]
    def secondarySources
        : Option[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]]
    def secondarySourceVersions
        : Option[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]]
    def artifacts: Option[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]
    def secondaryArtifacts
        : Option[List[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]]
    def cache: Option[zio.aws.codebuild.model.ProjectCache.ReadOnly]
    def environment: Option[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly]
    def serviceRole: Option[NonEmptyString]
    def logs: Option[zio.aws.codebuild.model.LogsLocation.ReadOnly]
    def timeoutInMinutes: Option[WrapperInt]
    def queuedTimeoutInMinutes: Option[WrapperInt]
    def buildComplete: Option[Boolean]
    def initiator: Option[String]
    def vpcConfig: Option[zio.aws.codebuild.model.VpcConfig.ReadOnly]
    def networkInterface
        : Option[zio.aws.codebuild.model.NetworkInterface.ReadOnly]
    def encryptionKey: Option[NonEmptyString]
    def exportedEnvironmentVariables: Option[
      List[zio.aws.codebuild.model.ExportedEnvironmentVariable.ReadOnly]
    ]
    def reportArns: Option[List[String]]
    def fileSystemLocations: Option[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ]
    def debugSession: Option[zio.aws.codebuild.model.DebugSession.ReadOnly]
    def buildBatchArn: Option[String]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getBuildNumber: ZIO[Any, AwsError, WrapperLong] =
      AwsError.unwrapOptionField("buildNumber", buildNumber)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCurrentPhase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentPhase", currentPhase)
    def getBuildStatus: ZIO[Any, AwsError, zio.aws.codebuild.model.StatusType] =
      AwsError.unwrapOptionField("buildStatus", buildStatus)
    def getSourceVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getResolvedSourceVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resolvedSourceVersion", resolvedSourceVersion)
    def getProjectName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getPhases: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildPhase.ReadOnly
    ]] = AwsError.unwrapOptionField("phases", phases)
    def getSource
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getSecondarySources: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSource.ReadOnly
    ]] = AwsError.unwrapOptionField("secondarySources", secondarySources)
    def getSecondarySourceVersions: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourceVersions",
      secondarySourceVersions
    )
    def getArtifacts
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildArtifacts.ReadOnly] =
      AwsError.unwrapOptionField("artifacts", artifacts)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildArtifacts.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
    def getCache
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      AwsError.unwrapOptionField("cache", cache)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getLogs
        : ZIO[Any, AwsError, zio.aws.codebuild.model.LogsLocation.ReadOnly] =
      AwsError.unwrapOptionField("logs", logs)
    def getTimeoutInMinutes: ZIO[Any, AwsError, WrapperInt] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getQueuedTimeoutInMinutes: ZIO[Any, AwsError, WrapperInt] = AwsError
      .unwrapOptionField("queuedTimeoutInMinutes", queuedTimeoutInMinutes)
    def getBuildComplete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("buildComplete", buildComplete)
    def getInitiator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("initiator", initiator)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getNetworkInterface: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.NetworkInterface.ReadOnly
    ] = AwsError.unwrapOptionField("networkInterface", networkInterface)
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getExportedEnvironmentVariables: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ExportedEnvironmentVariable.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "exportedEnvironmentVariables",
      exportedEnvironmentVariables
    )
    def getReportArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("reportArns", reportArns)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
    def getDebugSession
        : ZIO[Any, AwsError, zio.aws.codebuild.model.DebugSession.ReadOnly] =
      AwsError.unwrapOptionField("debugSession", debugSession)
    def getBuildBatchArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("buildBatchArn", buildBatchArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.Build
  ) extends zio.aws.codebuild.model.Build.ReadOnly {
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val buildNumber: Option[WrapperLong] = scala
      .Option(impl.buildNumber())
      .map(value => zio.aws.codebuild.model.primitives.WrapperLong(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val currentPhase: Option[String] =
      scala.Option(impl.currentPhase()).map(value => value: String)
    override val buildStatus: Option[zio.aws.codebuild.model.StatusType] = scala
      .Option(impl.buildStatus())
      .map(value => zio.aws.codebuild.model.StatusType.wrap(value))
    override val sourceVersion: Option[NonEmptyString] = scala
      .Option(impl.sourceVersion())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val resolvedSourceVersion: Option[NonEmptyString] = scala
      .Option(impl.resolvedSourceVersion())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val projectName: Option[NonEmptyString] = scala
      .Option(impl.projectName())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val phases
        : Option[List[zio.aws.codebuild.model.BuildPhase.ReadOnly]] = scala
      .Option(impl.phases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.BuildPhase.wrap(item)
        }.toList
      )
    override val source
        : Option[zio.aws.codebuild.model.ProjectSource.ReadOnly] = scala
      .Option(impl.source())
      .map(value => zio.aws.codebuild.model.ProjectSource.wrap(value))
    override val secondarySources
        : Option[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]] = scala
      .Option(impl.secondarySources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectSource.wrap(item)
        }.toList
      )
    override val secondarySourceVersions
        : Option[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]] =
      scala
        .Option(impl.secondarySourceVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectSourceVersion.wrap(item)
          }.toList
        )
    override val artifacts
        : Option[zio.aws.codebuild.model.BuildArtifacts.ReadOnly] = scala
      .Option(impl.artifacts())
      .map(value => zio.aws.codebuild.model.BuildArtifacts.wrap(value))
    override val secondaryArtifacts
        : Option[List[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]] = scala
      .Option(impl.secondaryArtifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.BuildArtifacts.wrap(item)
        }.toList
      )
    override val cache: Option[zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      scala
        .Option(impl.cache())
        .map(value => zio.aws.codebuild.model.ProjectCache.wrap(value))
    override val environment
        : Option[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.codebuild.model.ProjectEnvironment.wrap(value))
    override val serviceRole: Option[NonEmptyString] = scala
      .Option(impl.serviceRole())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val logs: Option[zio.aws.codebuild.model.LogsLocation.ReadOnly] =
      scala
        .Option(impl.logs())
        .map(value => zio.aws.codebuild.model.LogsLocation.wrap(value))
    override val timeoutInMinutes: Option[WrapperInt] = scala
      .Option(impl.timeoutInMinutes())
      .map(value => zio.aws.codebuild.model.primitives.WrapperInt(value))
    override val queuedTimeoutInMinutes: Option[WrapperInt] = scala
      .Option(impl.queuedTimeoutInMinutes())
      .map(value => zio.aws.codebuild.model.primitives.WrapperInt(value))
    override val buildComplete: Option[Boolean] =
      scala.Option(impl.buildComplete()).map(value => value: Boolean)
    override val initiator: Option[String] =
      scala.Option(impl.initiator()).map(value => value: String)
    override val vpcConfig: Option[zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.codebuild.model.VpcConfig.wrap(value))
    override val networkInterface
        : Option[zio.aws.codebuild.model.NetworkInterface.ReadOnly] = scala
      .Option(impl.networkInterface())
      .map(value => zio.aws.codebuild.model.NetworkInterface.wrap(value))
    override val encryptionKey: Option[NonEmptyString] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val exportedEnvironmentVariables: Option[
      List[zio.aws.codebuild.model.ExportedEnvironmentVariable.ReadOnly]
    ] = scala
      .Option(impl.exportedEnvironmentVariables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ExportedEnvironmentVariable.wrap(item)
        }.toList
      )
    override val reportArns: Option[List[String]] = scala
      .Option(impl.reportArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val fileSystemLocations: Option[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ] = scala
      .Option(impl.fileSystemLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectFileSystemLocation.wrap(item)
        }.toList
      )
    override val debugSession
        : Option[zio.aws.codebuild.model.DebugSession.ReadOnly] = scala
      .Option(impl.debugSession())
      .map(value => zio.aws.codebuild.model.DebugSession.wrap(value))
    override val buildBatchArn: Option[String] =
      scala.Option(impl.buildBatchArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.Build
  ): zio.aws.codebuild.model.Build.ReadOnly = new Wrapper(impl)
}
