package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.WrapperBoolean
import scala.jdk.CollectionConverters._
final case class BuildArtifacts(
    location: Option[String] = None,
    sha256sum: Option[String] = None,
    md5sum: Option[String] = None,
    overrideArtifactName: Option[WrapperBoolean] = None,
    encryptionDisabled: Option[WrapperBoolean] = None,
    artifactIdentifier: Option[String] = None,
    bucketOwnerAccess: Option[zio.aws.codebuild.model.BucketOwnerAccess] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildArtifacts = {
    import BuildArtifacts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildArtifacts
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(sha256sum.map(value => value: java.lang.String))(
        _.sha256sum
      )
      .optionallyWith(md5sum.map(value => value: java.lang.String))(_.md5sum)
      .optionallyWith(
        overrideArtifactName.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.overrideArtifactName)
      .optionallyWith(
        encryptionDisabled.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.encryptionDisabled)
      .optionallyWith(artifactIdentifier.map(value => value: java.lang.String))(
        _.artifactIdentifier
      )
      .optionallyWith(bucketOwnerAccess.map(value => value.unwrap))(
        _.bucketOwnerAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildArtifacts.ReadOnly =
    zio.aws.codebuild.model.BuildArtifacts.wrap(buildAwsValue())
}
object BuildArtifacts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildArtifacts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildArtifacts =
      zio.aws.codebuild.model.BuildArtifacts(
        location.map(value => value),
        sha256sum.map(value => value),
        md5sum.map(value => value),
        overrideArtifactName.map(value => value),
        encryptionDisabled.map(value => value),
        artifactIdentifier.map(value => value),
        bucketOwnerAccess.map(value => value)
      )
    def location: Option[String]
    def sha256sum: Option[String]
    def md5sum: Option[String]
    def overrideArtifactName: Option[WrapperBoolean]
    def encryptionDisabled: Option[WrapperBoolean]
    def artifactIdentifier: Option[String]
    def bucketOwnerAccess: Option[zio.aws.codebuild.model.BucketOwnerAccess]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getSha256sum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sha256sum", sha256sum)
    def getMd5sum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("md5sum", md5sum)
    def getOverrideArtifactName: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("overrideArtifactName", overrideArtifactName)
    def getEncryptionDisabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
    def getArtifactIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("artifactIdentifier", artifactIdentifier)
    def getBucketOwnerAccess
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BucketOwnerAccess] =
      AwsError.unwrapOptionField("bucketOwnerAccess", bucketOwnerAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildArtifacts
  ) extends zio.aws.codebuild.model.BuildArtifacts.ReadOnly {
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val sha256sum: Option[String] =
      scala.Option(impl.sha256sum()).map(value => value: String)
    override val md5sum: Option[String] =
      scala.Option(impl.md5sum()).map(value => value: String)
    override val overrideArtifactName: Option[WrapperBoolean] = scala
      .Option(impl.overrideArtifactName())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val encryptionDisabled: Option[WrapperBoolean] = scala
      .Option(impl.encryptionDisabled())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val artifactIdentifier: Option[String] =
      scala.Option(impl.artifactIdentifier()).map(value => value: String)
    override val bucketOwnerAccess
        : Option[zio.aws.codebuild.model.BucketOwnerAccess] = scala
      .Option(impl.bucketOwnerAccess())
      .map(value => zio.aws.codebuild.model.BucketOwnerAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildArtifacts
  ): zio.aws.codebuild.model.BuildArtifacts.ReadOnly = new Wrapper(impl)
}
