package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  Timestamp,
  NonNegativeInt,
  Percentage,
  NonEmptyString
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CodeCoverage(
    id: Option[NonEmptyString] = None,
    reportARN: Option[NonEmptyString] = None,
    filePath: Option[NonEmptyString] = None,
    lineCoveragePercentage: Option[Percentage] = None,
    linesCovered: Option[NonNegativeInt] = None,
    linesMissed: Option[NonNegativeInt] = None,
    branchCoveragePercentage: Option[Percentage] = None,
    branchesCovered: Option[NonNegativeInt] = None,
    branchesMissed: Option[NonNegativeInt] = None,
    expired: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CodeCoverage = {
    import CodeCoverage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CodeCoverage
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        reportARN.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reportARN)
      .optionallyWith(
        filePath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(
        lineCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.lineCoveragePercentage)
      .optionallyWith(
        linesCovered.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.linesCovered)
      .optionallyWith(
        linesMissed.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.linesMissed)
      .optionallyWith(
        branchCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.branchCoveragePercentage)
      .optionallyWith(
        branchesCovered.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.branchesCovered)
      .optionallyWith(
        branchesMissed.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.branchesMissed)
      .optionallyWith(expired.map(value => Timestamp.unwrap(value): Instant))(
        _.expired
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CodeCoverage.ReadOnly =
    zio.aws.codebuild.model.CodeCoverage.wrap(buildAwsValue())
}
object CodeCoverage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CodeCoverage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CodeCoverage =
      zio.aws.codebuild.model.CodeCoverage(
        id.map(value => value),
        reportARN.map(value => value),
        filePath.map(value => value),
        lineCoveragePercentage.map(value => value),
        linesCovered.map(value => value),
        linesMissed.map(value => value),
        branchCoveragePercentage.map(value => value),
        branchesCovered.map(value => value),
        branchesMissed.map(value => value),
        expired.map(value => value)
      )
    def id: Option[NonEmptyString]
    def reportARN: Option[NonEmptyString]
    def filePath: Option[NonEmptyString]
    def lineCoveragePercentage: Option[Percentage]
    def linesCovered: Option[NonNegativeInt]
    def linesMissed: Option[NonNegativeInt]
    def branchCoveragePercentage: Option[Percentage]
    def branchesCovered: Option[NonNegativeInt]
    def branchesMissed: Option[NonNegativeInt]
    def expired: Option[Timestamp]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getReportARN: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reportARN", reportARN)
    def getFilePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getLineCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("lineCoveragePercentage", lineCoveragePercentage)
    def getLinesCovered: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("linesCovered", linesCovered)
    def getLinesMissed: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("linesMissed", linesMissed)
    def getBranchCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("branchCoveragePercentage", branchCoveragePercentage)
    def getBranchesCovered: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("branchesCovered", branchesCovered)
    def getBranchesMissed: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("branchesMissed", branchesMissed)
    def getExpired: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expired", expired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CodeCoverage
  ) extends zio.aws.codebuild.model.CodeCoverage.ReadOnly {
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val reportARN: Option[NonEmptyString] = scala
      .Option(impl.reportARN())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val filePath: Option[NonEmptyString] = scala
      .Option(impl.filePath())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val lineCoveragePercentage: Option[Percentage] = scala
      .Option(impl.lineCoveragePercentage())
      .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
    override val linesCovered: Option[NonNegativeInt] = scala
      .Option(impl.linesCovered())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val linesMissed: Option[NonNegativeInt] = scala
      .Option(impl.linesMissed())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val branchCoveragePercentage: Option[Percentage] = scala
      .Option(impl.branchCoveragePercentage())
      .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
    override val branchesCovered: Option[NonNegativeInt] = scala
      .Option(impl.branchesCovered())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val branchesMissed: Option[NonNegativeInt] = scala
      .Option(impl.branchesMissed())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val expired: Option[Timestamp] = scala
      .Option(impl.expired())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CodeCoverage
  ): zio.aws.codebuild.model.CodeCoverage.ReadOnly = new Wrapper(impl)
}
