package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class EnvironmentVariable(
    name: NonEmptyString,
    value: String,
    `type`: Option[zio.aws.codebuild.model.EnvironmentVariableType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.EnvironmentVariable = {
    import EnvironmentVariable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.EnvironmentVariable
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .value(value: java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.EnvironmentVariable.ReadOnly =
    zio.aws.codebuild.model.EnvironmentVariable.wrap(buildAwsValue())
}
object EnvironmentVariable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.EnvironmentVariable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.EnvironmentVariable =
      zio.aws.codebuild.model
        .EnvironmentVariable(name, value, `type`.map(value => value))
    def name: NonEmptyString
    def value: String
    def `type`: Option[zio.aws.codebuild.model.EnvironmentVariableType]
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
    def getType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.EnvironmentVariableType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.EnvironmentVariable
  ) extends zio.aws.codebuild.model.EnvironmentVariable.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.name())
    override val value: String = impl.value(): String
    override val `type`
        : Option[zio.aws.codebuild.model.EnvironmentVariableType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.codebuild.model.EnvironmentVariableType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.EnvironmentVariable
  ): zio.aws.codebuild.model.EnvironmentVariable.ReadOnly = new Wrapper(impl)
}
