package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ImportSourceCredentialsResponse(
    arn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsResponse = {
    import ImportSourceCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsResponse
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ImportSourceCredentialsResponse.ReadOnly =
    zio.aws.codebuild.model.ImportSourceCredentialsResponse
      .wrap(buildAwsValue())
}
object ImportSourceCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ImportSourceCredentialsResponse =
      zio.aws.codebuild.model
        .ImportSourceCredentialsResponse(arn.map(value => value))
    def arn: Option[NonEmptyString]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsResponse
  ) extends zio.aws.codebuild.model.ImportSourceCredentialsResponse.ReadOnly {
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsResponse
  ): zio.aws.codebuild.model.ImportSourceCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
