package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.{NonEmptyString, PageSize}
import scala.jdk.CollectionConverters._
final case class ListSharedProjectsRequest(
    sortBy: Option[zio.aws.codebuild.model.SharedResourceSortByType] = None,
    sortOrder: Option[zio.aws.codebuild.model.SortOrderType] = None,
    maxResults: Option[PageSize] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest = {
    import ListSharedProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListSharedProjectsRequest.ReadOnly =
    zio.aws.codebuild.model.ListSharedProjectsRequest.wrap(buildAwsValue())
}
object ListSharedProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListSharedProjectsRequest =
      zio.aws.codebuild.model.ListSharedProjectsRequest(
        sortBy.map(value => value),
        sortOrder.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def sortBy: Option[zio.aws.codebuild.model.SharedResourceSortByType]
    def sortOrder: Option[zio.aws.codebuild.model.SortOrderType]
    def maxResults: Option[PageSize]
    def nextToken: Option[NonEmptyString]
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SharedResourceSortByType] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest
  ) extends zio.aws.codebuild.model.ListSharedProjectsRequest.ReadOnly {
    override val sortBy
        : Option[zio.aws.codebuild.model.SharedResourceSortByType] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.codebuild.model.SharedResourceSortByType.wrap(value)
      )
    override val sortOrder: Option[zio.aws.codebuild.model.SortOrderType] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest
  ): zio.aws.codebuild.model.ListSharedProjectsRequest.ReadOnly = new Wrapper(
    impl
  )
}
