package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ListSharedProjectsResponse(
    nextToken: Option[String] = None,
    projects: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse = {
    import ListSharedProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        projects.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.projects)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListSharedProjectsResponse.ReadOnly =
    zio.aws.codebuild.model.ListSharedProjectsResponse.wrap(buildAwsValue())
}
object ListSharedProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListSharedProjectsResponse =
      zio.aws.codebuild.model.ListSharedProjectsResponse(
        nextToken.map(value => value),
        projects.map(value => value)
      )
    def nextToken: Option[String]
    def projects: Option[List[NonEmptyString]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProjects: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("projects", projects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse
  ) extends zio.aws.codebuild.model.ListSharedProjectsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val projects: Option[List[NonEmptyString]] = scala
      .Option(impl.projects())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse
  ): zio.aws.codebuild.model.ListSharedProjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
