package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReportExportConfig(
    exportConfigType: Option[zio.aws.codebuild.model.ReportExportConfigType] =
      None,
    s3Destination: Option[zio.aws.codebuild.model.S3ReportExportConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ReportExportConfig = {
    import ReportExportConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ReportExportConfig
      .builder()
      .optionallyWith(exportConfigType.map(value => value.unwrap))(
        _.exportConfigType
      )
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ReportExportConfig.ReadOnly =
    zio.aws.codebuild.model.ReportExportConfig.wrap(buildAwsValue())
}
object ReportExportConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ReportExportConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ReportExportConfig =
      zio.aws.codebuild.model.ReportExportConfig(
        exportConfigType.map(value => value),
        s3Destination.map(value => value.asEditable)
      )
    def exportConfigType: Option[zio.aws.codebuild.model.ReportExportConfigType]
    def s3Destination
        : Option[zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly]
    def getExportConfigType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportExportConfigType] =
      AwsError.unwrapOptionField("exportConfigType", exportConfigType)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ReportExportConfig
  ) extends zio.aws.codebuild.model.ReportExportConfig.ReadOnly {
    override val exportConfigType
        : Option[zio.aws.codebuild.model.ReportExportConfigType] = scala
      .Option(impl.exportConfigType())
      .map(value => zio.aws.codebuild.model.ReportExportConfigType.wrap(value))
    override val s3Destination
        : Option[zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly] = scala
      .Option(impl.s3Destination())
      .map(value => zio.aws.codebuild.model.S3ReportExportConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ReportExportConfig
  ): zio.aws.codebuild.model.ReportExportConfig.ReadOnly = new Wrapper(impl)
}
