package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class SourceCredentialsInfo(
    arn: Option[NonEmptyString] = None,
    serverType: Option[zio.aws.codebuild.model.ServerType] = None,
    authType: Option[zio.aws.codebuild.model.AuthType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo = {
    import SourceCredentialsInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(serverType.map(value => value.unwrap))(_.serverType)
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.SourceCredentialsInfo.ReadOnly =
    zio.aws.codebuild.model.SourceCredentialsInfo.wrap(buildAwsValue())
}
object SourceCredentialsInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.SourceCredentialsInfo =
      zio.aws.codebuild.model.SourceCredentialsInfo(
        arn.map(value => value),
        serverType.map(value => value),
        authType.map(value => value)
      )
    def arn: Option[NonEmptyString]
    def serverType: Option[zio.aws.codebuild.model.ServerType]
    def authType: Option[zio.aws.codebuild.model.AuthType]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getServerType: ZIO[Any, AwsError, zio.aws.codebuild.model.ServerType] =
      AwsError.unwrapOptionField("serverType", serverType)
    def getAuthType: ZIO[Any, AwsError, zio.aws.codebuild.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo
  ) extends zio.aws.codebuild.model.SourceCredentialsInfo.ReadOnly {
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val serverType: Option[zio.aws.codebuild.model.ServerType] = scala
      .Option(impl.serverType())
      .map(value => zio.aws.codebuild.model.ServerType.wrap(value))
    override val authType: Option[zio.aws.codebuild.model.AuthType] = scala
      .Option(impl.authType())
      .map(value => zio.aws.codebuild.model.AuthType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo
  ): zio.aws.codebuild.model.SourceCredentialsInfo.ReadOnly = new Wrapper(impl)
}
