package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopBuildBatchResponse(
    buildBatch: Option[zio.aws.codebuild.model.BuildBatch] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.StopBuildBatchResponse = {
    import StopBuildBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.StopBuildBatchResponse
      .builder()
      .optionallyWith(buildBatch.map(value => value.buildAwsValue()))(
        _.buildBatch
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.StopBuildBatchResponse.ReadOnly =
    zio.aws.codebuild.model.StopBuildBatchResponse.wrap(buildAwsValue())
}
object StopBuildBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.StopBuildBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.StopBuildBatchResponse =
      zio.aws.codebuild.model
        .StopBuildBatchResponse(buildBatch.map(value => value.asEditable))
    def buildBatch: Option[zio.aws.codebuild.model.BuildBatch.ReadOnly]
    def getBuildBatch
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildBatch.ReadOnly] =
      AwsError.unwrapOptionField("buildBatch", buildBatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.StopBuildBatchResponse
  ) extends zio.aws.codebuild.model.StopBuildBatchResponse.ReadOnly {
    override val buildBatch
        : Option[zio.aws.codebuild.model.BuildBatch.ReadOnly] = scala
      .Option(impl.buildBatch())
      .map(value => zio.aws.codebuild.model.BuildBatch.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.StopBuildBatchResponse
  ): zio.aws.codebuild.model.StopBuildBatchResponse.ReadOnly = new Wrapper(impl)
}
