package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnvironmentPlatform(
    platform: Optional[zio.aws.codebuild.model.PlatformType] = Optional.Absent,
    languages: Optional[Iterable[zio.aws.codebuild.model.EnvironmentLanguage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform = {
    import EnvironmentPlatform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform
      .builder()
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        languages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.languages)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.EnvironmentPlatform.ReadOnly =
    zio.aws.codebuild.model.EnvironmentPlatform.wrap(buildAwsValue())
}
object EnvironmentPlatform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.EnvironmentPlatform =
      zio.aws.codebuild.model.EnvironmentPlatform(
        platform.map(value => value),
        languages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def platform: Optional[zio.aws.codebuild.model.PlatformType]
    def languages
        : Optional[List[zio.aws.codebuild.model.EnvironmentLanguage.ReadOnly]]
    def getPlatform: ZIO[Any, AwsError, zio.aws.codebuild.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getLanguages: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.EnvironmentLanguage.ReadOnly
    ]] = AwsError.unwrapOptionField("languages", languages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform
  ) extends zio.aws.codebuild.model.EnvironmentPlatform.ReadOnly {
    override val platform: Optional[zio.aws.codebuild.model.PlatformType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.codebuild.model.PlatformType.wrap(value))
    override val languages
        : Optional[List[zio.aws.codebuild.model.EnvironmentLanguage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.EnvironmentLanguage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform
  ): zio.aws.codebuild.model.EnvironmentPlatform.ReadOnly = new Wrapper(impl)
}
