package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyResponse(
    policy: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.codebuild.model.GetResourcePolicyResponse.wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.GetResourcePolicyResponse =
      zio.aws.codebuild.model
        .GetResourcePolicyResponse(policy.map(value => value))
    def policy: Optional[NonEmptyString]
    def getPolicy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.GetResourcePolicyResponse
  ) extends zio.aws.codebuild.model.GetResourcePolicyResponse.ReadOnly {
    override val policy: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.GetResourcePolicyResponse
  ): zio.aws.codebuild.model.GetResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
