package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{WrapperBoolean, GitCloneDepth}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProjectSource(
    `type`: zio.aws.codebuild.model.SourceType,
    location: Optional[String] = Optional.Absent,
    gitCloneDepth: Optional[GitCloneDepth] = Optional.Absent,
    gitSubmodulesConfig: Optional[zio.aws.codebuild.model.GitSubmodulesConfig] =
      Optional.Absent,
    buildspec: Optional[String] = Optional.Absent,
    auth: Optional[zio.aws.codebuild.model.SourceAuth] = Optional.Absent,
    reportBuildStatus: Optional[WrapperBoolean] = Optional.Absent,
    buildStatusConfig: Optional[zio.aws.codebuild.model.BuildStatusConfig] =
      Optional.Absent,
    insecureSsl: Optional[WrapperBoolean] = Optional.Absent,
    sourceIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectSource = {
    import ProjectSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectSource
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(
        gitCloneDepth.map(value => GitCloneDepth.unwrap(value): Integer)
      )(_.gitCloneDepth)
      .optionallyWith(gitSubmodulesConfig.map(value => value.buildAwsValue()))(
        _.gitSubmodulesConfig
      )
      .optionallyWith(buildspec.map(value => value: java.lang.String))(
        _.buildspec
      )
      .optionallyWith(auth.map(value => value.buildAwsValue()))(_.auth)
      .optionallyWith(reportBuildStatus.map(value => value: java.lang.Boolean))(
        _.reportBuildStatus
      )
      .optionallyWith(buildStatusConfig.map(value => value.buildAwsValue()))(
        _.buildStatusConfig
      )
      .optionallyWith(insecureSsl.map(value => value: java.lang.Boolean))(
        _.insecureSsl
      )
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectSource.ReadOnly =
    zio.aws.codebuild.model.ProjectSource.wrap(buildAwsValue())
}
object ProjectSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectSource =
      zio.aws.codebuild.model.ProjectSource(
        `type`,
        location.map(value => value),
        gitCloneDepth.map(value => value),
        gitSubmodulesConfig.map(value => value.asEditable),
        buildspec.map(value => value),
        auth.map(value => value.asEditable),
        reportBuildStatus.map(value => value),
        buildStatusConfig.map(value => value.asEditable),
        insecureSsl.map(value => value),
        sourceIdentifier.map(value => value)
      )
    def `type`: zio.aws.codebuild.model.SourceType
    def location: Optional[String]
    def gitCloneDepth: Optional[GitCloneDepth]
    def gitSubmodulesConfig
        : Optional[zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly]
    def buildspec: Optional[String]
    def auth: Optional[zio.aws.codebuild.model.SourceAuth.ReadOnly]
    def reportBuildStatus: Optional[WrapperBoolean]
    def buildStatusConfig
        : Optional[zio.aws.codebuild.model.BuildStatusConfig.ReadOnly]
    def insecureSsl: Optional[WrapperBoolean]
    def sourceIdentifier: Optional[String]
    def getType: ZIO[Any, Nothing, zio.aws.codebuild.model.SourceType] =
      ZIO.succeed(`type`)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getGitCloneDepth: ZIO[Any, AwsError, GitCloneDepth] =
      AwsError.unwrapOptionField("gitCloneDepth", gitCloneDepth)
    def getGitSubmodulesConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly
    ] = AwsError.unwrapOptionField("gitSubmodulesConfig", gitSubmodulesConfig)
    def getBuildspec: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("buildspec", buildspec)
    def getAuth
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SourceAuth.ReadOnly] =
      AwsError.unwrapOptionField("auth", auth)
    def getReportBuildStatus: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("reportBuildStatus", reportBuildStatus)
    def getBuildStatusConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.BuildStatusConfig.ReadOnly
    ] = AwsError.unwrapOptionField("buildStatusConfig", buildStatusConfig)
    def getInsecureSsl: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("insecureSsl", insecureSsl)
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectSource
  ) extends zio.aws.codebuild.model.ProjectSource.ReadOnly {
    override val `type`: zio.aws.codebuild.model.SourceType =
      zio.aws.codebuild.model.SourceType.wrap(impl.`type`())
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val gitCloneDepth: Optional[GitCloneDepth] = zio.aws.core.internal
      .optionalFromNullable(impl.gitCloneDepth())
      .map(value => zio.aws.codebuild.model.primitives.GitCloneDepth(value))
    override val gitSubmodulesConfig
        : Optional[zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gitSubmodulesConfig())
        .map(value => zio.aws.codebuild.model.GitSubmodulesConfig.wrap(value))
    override val buildspec: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.buildspec())
      .map(value => value: String)
    override val auth: Optional[zio.aws.codebuild.model.SourceAuth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auth())
        .map(value => zio.aws.codebuild.model.SourceAuth.wrap(value))
    override val reportBuildStatus: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportBuildStatus())
        .map(value => value: WrapperBoolean)
    override val buildStatusConfig
        : Optional[zio.aws.codebuild.model.BuildStatusConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildStatusConfig())
        .map(value => zio.aws.codebuild.model.BuildStatusConfig.wrap(value))
    override val insecureSsl: Optional[WrapperBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.insecureSsl())
      .map(value => value: WrapperBoolean)
    override val sourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectSource
  ): zio.aws.codebuild.model.ProjectSource.ReadOnly = new Wrapper(impl)
}
