package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReportExportConfig(
    exportConfigType: Optional[zio.aws.codebuild.model.ReportExportConfigType] =
      Optional.Absent,
    s3Destination: Optional[zio.aws.codebuild.model.S3ReportExportConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ReportExportConfig = {
    import ReportExportConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ReportExportConfig
      .builder()
      .optionallyWith(exportConfigType.map(value => value.unwrap))(
        _.exportConfigType
      )
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ReportExportConfig.ReadOnly =
    zio.aws.codebuild.model.ReportExportConfig.wrap(buildAwsValue())
}
object ReportExportConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ReportExportConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ReportExportConfig =
      zio.aws.codebuild.model.ReportExportConfig(
        exportConfigType.map(value => value),
        s3Destination.map(value => value.asEditable)
      )
    def exportConfigType
        : Optional[zio.aws.codebuild.model.ReportExportConfigType]
    def s3Destination
        : Optional[zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly]
    def getExportConfigType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportExportConfigType] =
      AwsError.unwrapOptionField("exportConfigType", exportConfigType)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ReportExportConfig
  ) extends zio.aws.codebuild.model.ReportExportConfig.ReadOnly {
    override val exportConfigType
        : Optional[zio.aws.codebuild.model.ReportExportConfigType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportConfigType())
        .map(value =>
          zio.aws.codebuild.model.ReportExportConfigType.wrap(value)
        )
    override val s3Destination
        : Optional[zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Destination())
        .map(value => zio.aws.codebuild.model.S3ReportExportConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ReportExportConfig
  ): zio.aws.codebuild.model.ReportExportConfig.ReadOnly = new Wrapper(impl)
}
