package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class UpdateProjectVisibilityRequest(
    projectArn: NonEmptyString,
    projectVisibility: zio.aws.codebuild.model.ProjectVisibilityType,
    resourceAccessRole: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityRequest = {
    import UpdateProjectVisibilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityRequest
      .builder()
      .projectArn(NonEmptyString.unwrap(projectArn): java.lang.String)
      .projectVisibility(projectVisibility.unwrap)
      .optionallyWith(
        resourceAccessRole.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceAccessRole)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.UpdateProjectVisibilityRequest.ReadOnly =
    zio.aws.codebuild.model.UpdateProjectVisibilityRequest.wrap(buildAwsValue())
}
object UpdateProjectVisibilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.UpdateProjectVisibilityRequest =
      zio.aws.codebuild.model.UpdateProjectVisibilityRequest(
        projectArn,
        projectVisibility,
        resourceAccessRole.map(value => value)
      )
    def projectArn: NonEmptyString
    def projectVisibility: zio.aws.codebuild.model.ProjectVisibilityType
    def resourceAccessRole: Optional[NonEmptyString]
    def getProjectArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(projectArn)
    def getProjectVisibility
        : ZIO[Any, Nothing, zio.aws.codebuild.model.ProjectVisibilityType] =
      ZIO.succeed(projectVisibility)
    def getResourceAccessRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceAccessRole", resourceAccessRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityRequest
  ) extends zio.aws.codebuild.model.UpdateProjectVisibilityRequest.ReadOnly {
    override val projectArn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.projectArn())
    override val projectVisibility
        : zio.aws.codebuild.model.ProjectVisibilityType =
      zio.aws.codebuild.model.ProjectVisibilityType
        .wrap(impl.projectVisibility())
    override val resourceAccessRole: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAccessRole())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityRequest
  ): zio.aws.codebuild.model.UpdateProjectVisibilityRequest.ReadOnly =
    new Wrapper(impl)
}
