package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class BatchGetBuildsResponse(
    builds: Optional[Iterable[zio.aws.codebuild.model.Build]] = Optional.Absent,
    buildsNotFound: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse = {
    import BatchGetBuildsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse
      .builder()
      .optionallyWith(
        builds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.builds)
      .optionallyWith(
        buildsNotFound.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.buildsNotFound)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchGetBuildsResponse.ReadOnly =
    zio.aws.codebuild.model.BatchGetBuildsResponse.wrap(buildAwsValue())
}
object BatchGetBuildsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetBuildsResponse =
      zio.aws.codebuild.model.BatchGetBuildsResponse(
        builds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        buildsNotFound.map(value => value)
      )
    def builds: Optional[List[zio.aws.codebuild.model.Build.ReadOnly]]
    def buildsNotFound: Optional[List[NonEmptyString]]
    def getBuilds
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Build.ReadOnly]] =
      AwsError.unwrapOptionField("builds", builds)
    def getBuildsNotFound: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("buildsNotFound", buildsNotFound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse
  ) extends zio.aws.codebuild.model.BatchGetBuildsResponse.ReadOnly {
    override val builds
        : Optional[List[zio.aws.codebuild.model.Build.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.builds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.Build.wrap(item)
          }.toList
        )
    override val buildsNotFound: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildsNotFound())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse
  ): zio.aws.codebuild.model.BatchGetBuildsResponse.ReadOnly = new Wrapper(impl)
}
