package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait BucketOwnerAccess {
  def unwrap: software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess
}
object BucketOwnerAccess {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess
  ): zio.aws.codebuild.model.BucketOwnerAccess = value match {
    case software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess.READ_ONLY =>
      val r = READ_ONLY
      r
    case software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess.FULL =>
      val r = FULL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.BucketOwnerAccess {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess =
      software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.codebuild.model.BucketOwnerAccess {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess =
      software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess.NONE
  }
  case object READ_ONLY extends zio.aws.codebuild.model.BucketOwnerAccess {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess =
      software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess.READ_ONLY
  }
  case object FULL extends zio.aws.codebuild.model.BucketOwnerAccess {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess =
      software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess.FULL
  }
}
