package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateReportGroupResponse(
    reportGroup: Optional[zio.aws.codebuild.model.ReportGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CreateReportGroupResponse = {
    import CreateReportGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CreateReportGroupResponse
      .builder()
      .optionallyWith(reportGroup.map(value => value.buildAwsValue()))(
        _.reportGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CreateReportGroupResponse.ReadOnly =
    zio.aws.codebuild.model.CreateReportGroupResponse.wrap(buildAwsValue())
}
object CreateReportGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CreateReportGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CreateReportGroupResponse =
      zio.aws.codebuild.model
        .CreateReportGroupResponse(reportGroup.map(value => value.asEditable))
    def reportGroup: Optional[zio.aws.codebuild.model.ReportGroup.ReadOnly]
    def getReportGroup
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportGroup.ReadOnly] =
      AwsError.unwrapOptionField("reportGroup", reportGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CreateReportGroupResponse
  ) extends zio.aws.codebuild.model.CreateReportGroupResponse.ReadOnly {
    override val reportGroup
        : Optional[zio.aws.codebuild.model.ReportGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportGroup())
        .map(value => zio.aws.codebuild.model.ReportGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CreateReportGroupResponse
  ): zio.aws.codebuild.model.CreateReportGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
