package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ExportedEnvironmentVariable(
    name: Optional[NonEmptyString] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ExportedEnvironmentVariable = {
    import ExportedEnvironmentVariable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ExportedEnvironmentVariable
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ExportedEnvironmentVariable.ReadOnly =
    zio.aws.codebuild.model.ExportedEnvironmentVariable.wrap(buildAwsValue())
}
object ExportedEnvironmentVariable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ExportedEnvironmentVariable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ExportedEnvironmentVariable =
      zio.aws.codebuild.model.ExportedEnvironmentVariable(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def value: Optional[String]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ExportedEnvironmentVariable
  ) extends zio.aws.codebuild.model.ExportedEnvironmentVariable.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ExportedEnvironmentVariable
  ): zio.aws.codebuild.model.ExportedEnvironmentVariable.ReadOnly = new Wrapper(
    impl
  )
}
