package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSourceCredentialsResponse(
    sourceCredentialsInfos: Optional[
      Iterable[zio.aws.codebuild.model.SourceCredentialsInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsResponse = {
    import ListSourceCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsResponse
      .builder()
      .optionallyWith(
        sourceCredentialsInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceCredentialsInfos)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListSourceCredentialsResponse.ReadOnly =
    zio.aws.codebuild.model.ListSourceCredentialsResponse.wrap(buildAwsValue())
}
object ListSourceCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListSourceCredentialsResponse =
      zio.aws.codebuild.model.ListSourceCredentialsResponse(
        sourceCredentialsInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceCredentialsInfos
        : Optional[List[zio.aws.codebuild.model.SourceCredentialsInfo.ReadOnly]]
    def getSourceCredentialsInfos: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.SourceCredentialsInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceCredentialsInfos",
      sourceCredentialsInfos
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsResponse
  ) extends zio.aws.codebuild.model.ListSourceCredentialsResponse.ReadOnly {
    override val sourceCredentialsInfos: Optional[
      List[zio.aws.codebuild.model.SourceCredentialsInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCredentialsInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.SourceCredentialsInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsResponse
  ): zio.aws.codebuild.model.ListSourceCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
