package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.{WrapperBoolean, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class ProjectEnvironment(
    `type`: zio.aws.codebuild.model.EnvironmentType,
    image: NonEmptyString,
    computeType: zio.aws.codebuild.model.ComputeType,
    environmentVariables: Optional[
      Iterable[zio.aws.codebuild.model.EnvironmentVariable]
    ] = Optional.Absent,
    privilegedMode: Optional[WrapperBoolean] = Optional.Absent,
    certificate: Optional[String] = Optional.Absent,
    registryCredential: Optional[zio.aws.codebuild.model.RegistryCredential] =
      Optional.Absent,
    imagePullCredentialsType: Optional[
      zio.aws.codebuild.model.ImagePullCredentialsType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectEnvironment = {
    import ProjectEnvironment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectEnvironment
      .builder()
      .`type`(`type`.unwrap)
      .image(NonEmptyString.unwrap(image): java.lang.String)
      .computeType(computeType.unwrap)
      .optionallyWith(
        environmentVariables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentVariables)
      .optionallyWith(privilegedMode.map(value => value: java.lang.Boolean))(
        _.privilegedMode
      )
      .optionallyWith(certificate.map(value => value: java.lang.String))(
        _.certificate
      )
      .optionallyWith(registryCredential.map(value => value.buildAwsValue()))(
        _.registryCredential
      )
      .optionallyWith(imagePullCredentialsType.map(value => value.unwrap))(
        _.imagePullCredentialsType
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectEnvironment.ReadOnly =
    zio.aws.codebuild.model.ProjectEnvironment.wrap(buildAwsValue())
}
object ProjectEnvironment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectEnvironment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectEnvironment =
      zio.aws.codebuild.model.ProjectEnvironment(
        `type`,
        image,
        computeType,
        environmentVariables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privilegedMode.map(value => value),
        certificate.map(value => value),
        registryCredential.map(value => value.asEditable),
        imagePullCredentialsType.map(value => value)
      )
    def `type`: zio.aws.codebuild.model.EnvironmentType
    def image: NonEmptyString
    def computeType: zio.aws.codebuild.model.ComputeType
    def environmentVariables
        : Optional[List[zio.aws.codebuild.model.EnvironmentVariable.ReadOnly]]
    def privilegedMode: Optional[WrapperBoolean]
    def certificate: Optional[String]
    def registryCredential
        : Optional[zio.aws.codebuild.model.RegistryCredential.ReadOnly]
    def imagePullCredentialsType
        : Optional[zio.aws.codebuild.model.ImagePullCredentialsType]
    def getType: ZIO[Any, Nothing, zio.aws.codebuild.model.EnvironmentType] =
      ZIO.succeed(`type`)
    def getImage: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(image)
    def getComputeType: ZIO[Any, Nothing, zio.aws.codebuild.model.ComputeType] =
      ZIO.succeed(computeType)
    def getEnvironmentVariables: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.EnvironmentVariable.ReadOnly
    ]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getPrivilegedMode: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("privilegedMode", privilegedMode)
    def getCertificate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getRegistryCredential: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.RegistryCredential.ReadOnly
    ] = AwsError.unwrapOptionField("registryCredential", registryCredential)
    def getImagePullCredentialsType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ImagePullCredentialsType] =
      AwsError.unwrapOptionField(
        "imagePullCredentialsType",
        imagePullCredentialsType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectEnvironment
  ) extends zio.aws.codebuild.model.ProjectEnvironment.ReadOnly {
    override val `type`: zio.aws.codebuild.model.EnvironmentType =
      zio.aws.codebuild.model.EnvironmentType.wrap(impl.`type`())
    override val image: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.image())
    override val computeType: zio.aws.codebuild.model.ComputeType =
      zio.aws.codebuild.model.ComputeType.wrap(impl.computeType())
    override val environmentVariables
        : Optional[List[zio.aws.codebuild.model.EnvironmentVariable.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentVariables())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.EnvironmentVariable.wrap(item)
          }.toList
        )
    override val privilegedMode: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privilegedMode())
        .map(value => value: WrapperBoolean)
    override val certificate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value => value: String)
    override val registryCredential
        : Optional[zio.aws.codebuild.model.RegistryCredential.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registryCredential())
        .map(value => zio.aws.codebuild.model.RegistryCredential.wrap(value))
    override val imagePullCredentialsType
        : Optional[zio.aws.codebuild.model.ImagePullCredentialsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePullCredentialsType())
        .map(value =>
          zio.aws.codebuild.model.ImagePullCredentialsType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectEnvironment
  ): zio.aws.codebuild.model.ProjectEnvironment.ReadOnly = new Wrapper(impl)
}
