package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  ForceUnsubscribeAll,
  TargetAddress
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTargetRequest(
    targetAddress: TargetAddress,
    forceUnsubscribeAll: Optional[ForceUnsubscribeAll] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetRequest = {
    import DeleteTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetRequest
      .builder()
      .targetAddress(TargetAddress.unwrap(targetAddress): java.lang.String)
      .optionallyWith(
        forceUnsubscribeAll.map(value =>
          ForceUnsubscribeAll.unwrap(value): java.lang.Boolean
        )
      )(_.forceUnsubscribeAll)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.DeleteTargetRequest.ReadOnly =
    zio.aws.codestarnotifications.model.DeleteTargetRequest
      .wrap(buildAwsValue())
}
object DeleteTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.DeleteTargetRequest =
      zio.aws.codestarnotifications.model.DeleteTargetRequest(
        targetAddress,
        forceUnsubscribeAll.map(value => value)
      )
    def targetAddress: TargetAddress
    def forceUnsubscribeAll: Optional[ForceUnsubscribeAll]
    def getTargetAddress: ZIO[Any, Nothing, TargetAddress] =
      ZIO.succeed(targetAddress)
    def getForceUnsubscribeAll: ZIO[Any, AwsError, ForceUnsubscribeAll] =
      AwsError.unwrapOptionField("forceUnsubscribeAll", forceUnsubscribeAll)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetRequest
  ) extends zio.aws.codestarnotifications.model.DeleteTargetRequest.ReadOnly {
    override val targetAddress: TargetAddress =
      zio.aws.codestarnotifications.model.primitives
        .TargetAddress(impl.targetAddress())
    override val forceUnsubscribeAll: Optional[ForceUnsubscribeAll] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceUnsubscribeAll())
        .map(value =>
          zio.aws.codestarnotifications.model.primitives
            .ForceUnsubscribeAll(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetRequest
  ): zio.aws.codestarnotifications.model.DeleteTargetRequest.ReadOnly =
    new Wrapper(impl)
}
