package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  TagValue,
  TagKey,
  NotificationRuleArn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    arn: NotificationRuleArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.TagResourceRequest
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.TagResourceRequest.ReadOnly =
    zio.aws.codestarnotifications.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.TagResourceRequest =
      zio.aws.codestarnotifications.model.TagResourceRequest(arn, tags)
    def arn: NotificationRuleArn
    def tags: Map[TagKey, TagValue]
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.TagResourceRequest
  ) extends zio.aws.codestarnotifications.model.TagResourceRequest.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.codestarnotifications.model.primitives.TagKey(
          key
        ) -> zio.aws.codestarnotifications.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.TagResourceRequest
  ): zio.aws.codestarnotifications.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
