package zio.aws.codestarnotifications.model
import scala.jdk.CollectionConverters._
sealed trait TargetStatus {
  def unwrap
      : software.amazon.awssdk.services.codestarnotifications.model.TargetStatus
}
object TargetStatus {
  def wrap(
      value: software.amazon.awssdk.services.codestarnotifications.model.TargetStatus
  ): zio.aws.codestarnotifications.model.TargetStatus = value match {
    case software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.UNREACHABLE =>
      val r = UNREACHABLE
      r
    case software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.DEACTIVATED =>
      val r = DEACTIVATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codestarnotifications.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.TargetStatus =
      software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.codestarnotifications.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.TargetStatus =
      software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.PENDING
  }
  case object ACTIVE extends zio.aws.codestarnotifications.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.TargetStatus =
      software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.ACTIVE
  }
  case object UNREACHABLE
      extends zio.aws.codestarnotifications.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.TargetStatus =
      software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.UNREACHABLE
  }
  case object INACTIVE
      extends zio.aws.codestarnotifications.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.TargetStatus =
      software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.INACTIVE
  }
  case object DEACTIVATED
      extends zio.aws.codestarnotifications.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.TargetStatus =
      software.amazon.awssdk.services.codestarnotifications.model.TargetStatus.DEACTIVATED
  }
}
