package zio.aws.codestarnotifications
import zio.prelude.Subtype
import zio.aws.codestarnotifications.model.primitives.{
  TagValue,
  TagKey,
  EventTypeId
}
import java.time.Instant
import zio.aws.codestarnotifications.model.primitives.ClientRequestToken.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.codestarnotifications.model.primitives.ClientRequestToken.Type
    object CreatedTimestamp extends Subtype[Instant]
    type CreatedTimestamp =
      zio.aws.codestarnotifications.model.primitives.CreatedTimestamp.Type
    object EventTypeId extends Subtype[String]
    type EventTypeId =
      zio.aws.codestarnotifications.model.primitives.EventTypeId.Type
    object EventTypeName extends Subtype[String]
    type EventTypeName =
      zio.aws.codestarnotifications.model.primitives.EventTypeName.Type
    object ForceUnsubscribeAll extends Subtype[Boolean]
    type ForceUnsubscribeAll =
      zio.aws.codestarnotifications.model.primitives.ForceUnsubscribeAll.Type
    object LastModifiedTimestamp extends Subtype[Instant]
    type LastModifiedTimestamp =
      zio.aws.codestarnotifications.model.primitives.LastModifiedTimestamp.Type
    object ListEventTypesFilterValue extends Subtype[String]
    type ListEventTypesFilterValue =
      zio.aws.codestarnotifications.model.primitives.ListEventTypesFilterValue.Type
    object ListNotificationRulesFilterValue extends Subtype[String]
    type ListNotificationRulesFilterValue =
      zio.aws.codestarnotifications.model.primitives.ListNotificationRulesFilterValue.Type
    object ListTargetsFilterValue extends Subtype[String]
    type ListTargetsFilterValue =
      zio.aws.codestarnotifications.model.primitives.ListTargetsFilterValue.Type
    object MaxResults extends Subtype[Int]
    type MaxResults =
      zio.aws.codestarnotifications.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken =
      zio.aws.codestarnotifications.model.primitives.NextToken.Type
    object NotificationRuleArn extends Subtype[String]
    type NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives.NotificationRuleArn.Type
    object NotificationRuleCreatedBy extends Subtype[String]
    type NotificationRuleCreatedBy =
      zio.aws.codestarnotifications.model.primitives.NotificationRuleCreatedBy.Type
    object NotificationRuleId extends Subtype[String]
    type NotificationRuleId =
      zio.aws.codestarnotifications.model.primitives.NotificationRuleId.Type
    object NotificationRuleName extends Subtype[String]
    type NotificationRuleName =
      zio.aws.codestarnotifications.model.primitives.NotificationRuleName.Type
    object NotificationRuleResource extends Subtype[String]
    type NotificationRuleResource =
      zio.aws.codestarnotifications.model.primitives.NotificationRuleResource.Type
    object ResourceType extends Subtype[String]
    type ResourceType =
      zio.aws.codestarnotifications.model.primitives.ResourceType.Type
    object ServiceName extends Subtype[String]
    type ServiceName =
      zio.aws.codestarnotifications.model.primitives.ServiceName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.codestarnotifications.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.codestarnotifications.model.primitives.TagValue.Type
    object TargetAddress extends Subtype[String]
    type TargetAddress =
      zio.aws.codestarnotifications.model.primitives.TargetAddress.Type
    object TargetType extends Subtype[String]
    type TargetType =
      zio.aws.codestarnotifications.model.primitives.TargetType.Type
  }
  type EventTypeBatch =
    List[zio.aws.codestarnotifications.model.EventTypeSummary]
  type EventTypeIds = List[EventTypeId]
  type ListEventTypesFilters =
    List[zio.aws.codestarnotifications.model.ListEventTypesFilter]
  type ListNotificationRulesFilters =
    List[zio.aws.codestarnotifications.model.ListNotificationRulesFilter]
  type ListTargetsFilters =
    List[zio.aws.codestarnotifications.model.ListTargetsFilter]
  type NotificationRuleBatch =
    List[zio.aws.codestarnotifications.model.NotificationRuleSummary]
  type TagKeys = List[TagKey]
  type Tags = Map[TagKey, TagValue]
  type Targets = List[zio.aws.codestarnotifications.model.Target]
  type TargetsBatch = List[zio.aws.codestarnotifications.model.TargetSummary]
}
