package zio.aws.connectcontactlens
import zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest
import software.amazon.awssdk.services.connectcontactlens.model.{
  RealtimeContactAnalysisSegment,
  ListRealtimeContactAnalysisSegmentsResponse
}
import software.amazon.awssdk.services.connectcontactlens.{
  ConnectContactLensAsyncClientBuilder,
  ConnectContactLensAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait ConnectContactLens extends AspectSupport[ConnectContactLens] {
  val api: ConnectContactLensAsyncClient
  def listRealtimeContactAnalysisSegments(
      request: ListRealtimeContactAnalysisSegmentsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly
  ]
  def listRealtimeContactAnalysisSegmentsPaginated(
      request: ListRealtimeContactAnalysisSegmentsRequest
  ): IO[AwsError, ReadOnly]
}
object ConnectContactLens {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ConnectContactLens] =
    customized(identity)
  def customized(
      customization: ConnectContactLensAsyncClientBuilder => ConnectContactLensAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ConnectContactLens] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ConnectContactLensAsyncClientBuilder => ConnectContactLensAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ConnectContactLens] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ConnectContactLensAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      ConnectContactLensAsyncClient,
      ConnectContactLensAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      ConnectContactLensAsyncClient,
      ConnectContactLensAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ConnectContactLensImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ConnectContactLensImpl[R](
      override val api: ConnectContactLensAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ConnectContactLens
      with AwsServiceBase[R] {
    override val serviceName: String = "ConnectContactLens"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ConnectContactLensImpl[R1] =
      new ConnectContactLensImpl(api, newAspect, r)
    def listRealtimeContactAnalysisSegments(
        request: ListRealtimeContactAnalysisSegmentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest,
      ListRealtimeContactAnalysisSegmentsResponse,
      RealtimeContactAnalysisSegment
    ](
      "listRealtimeContactAnalysisSegments",
      api.listRealtimeContactAnalysisSegments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.segments().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment
          .wrap(item)
      )
      .provideEnvironment(r)
    def listRealtimeContactAnalysisSegmentsPaginated(
        request: ListRealtimeContactAnalysisSegmentsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest,
      ListRealtimeContactAnalysisSegmentsResponse
    ](
      "listRealtimeContactAnalysisSegments",
      api.listRealtimeContactAnalysisSegments
    )(request.buildAwsValue())
      .map(
        zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse.wrap
      )
      .provideEnvironment(r)
  }
  def listRealtimeContactAnalysisSegments(
      request: ListRealtimeContactAnalysisSegmentsRequest
  ): ZStream[
    zio.aws.connectcontactlens.ConnectContactLens,
    AwsError,
    zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly
  ] = ZStream.serviceWithStream(_.listRealtimeContactAnalysisSegments(request))
  def listRealtimeContactAnalysisSegmentsPaginated(
      request: ListRealtimeContactAnalysisSegmentsRequest
  ): ZIO[zio.aws.connectcontactlens.ConnectContactLens, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listRealtimeContactAnalysisSegmentsPaginated(request))
}
