package zio.aws.connectcontactlens.model
import zio.aws.connectcontactlens.model.primitives.CategoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Categories(
    matchedCategories: Iterable[CategoryName],
    matchedDetails: Map[
      CategoryName,
      zio.aws.connectcontactlens.model.CategoryDetails
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcontactlens.model.Categories = {
    import Categories.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcontactlens.model.Categories
      .builder()
      .matchedCategories(matchedCategories.map { item =>
        CategoryName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .matchedDetails(
        matchedDetails
          .map({ case (key, value) =>
            (CategoryName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.connectcontactlens.model.Categories.ReadOnly =
    zio.aws.connectcontactlens.model.Categories.wrap(buildAwsValue())
}
object Categories {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcontactlens.model.Categories
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcontactlens.model.Categories =
      zio.aws.connectcontactlens.model.Categories(
        matchedCategories,
        matchedDetails.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def matchedCategories: List[CategoryName]
    def matchedDetails: Map[
      CategoryName,
      zio.aws.connectcontactlens.model.CategoryDetails.ReadOnly
    ]
    def getMatchedCategories: ZIO[Any, Nothing, List[CategoryName]] =
      ZIO.succeed(matchedCategories)
    def getMatchedDetails: ZIO[Any, Nothing, Map[
      CategoryName,
      zio.aws.connectcontactlens.model.CategoryDetails.ReadOnly
    ]] = ZIO.succeed(matchedDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcontactlens.model.Categories
  ) extends zio.aws.connectcontactlens.model.Categories.ReadOnly {
    override val matchedCategories: List[CategoryName] = impl
      .matchedCategories()
      .asScala
      .map { item =>
        zio.aws.connectcontactlens.model.primitives.CategoryName(item)
      }
      .toList
    override val matchedDetails: Map[
      CategoryName,
      zio.aws.connectcontactlens.model.CategoryDetails.ReadOnly
    ] = impl
      .matchedDetails()
      .asScala
      .map({ case (key, value) =>
        zio.aws.connectcontactlens.model.primitives.CategoryName(
          key
        ) -> zio.aws.connectcontactlens.model.CategoryDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcontactlens.model.Categories
  ): zio.aws.connectcontactlens.model.Categories.ReadOnly = new Wrapper(impl)
}
