package zio.aws.connectcontactlens.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IssueDetected(
    characterOffsets: zio.aws.connectcontactlens.model.CharacterOffsets
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcontactlens.model.IssueDetected = {
    import IssueDetected.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcontactlens.model.IssueDetected
      .builder()
      .characterOffsets(characterOffsets.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connectcontactlens.model.IssueDetected.ReadOnly =
    zio.aws.connectcontactlens.model.IssueDetected.wrap(buildAwsValue())
}
object IssueDetected {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcontactlens.model.IssueDetected
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcontactlens.model.IssueDetected =
      zio.aws.connectcontactlens.model
        .IssueDetected(characterOffsets.asEditable)
    def characterOffsets
        : zio.aws.connectcontactlens.model.CharacterOffsets.ReadOnly
    def getCharacterOffsets: ZIO[
      Any,
      Nothing,
      zio.aws.connectcontactlens.model.CharacterOffsets.ReadOnly
    ] = ZIO.succeed(characterOffsets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcontactlens.model.IssueDetected
  ) extends zio.aws.connectcontactlens.model.IssueDetected.ReadOnly {
    override val characterOffsets
        : zio.aws.connectcontactlens.model.CharacterOffsets.ReadOnly =
      zio.aws.connectcontactlens.model.CharacterOffsets
        .wrap(impl.characterOffsets())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcontactlens.model.IssueDetected
  ): zio.aws.connectcontactlens.model.IssueDetected.ReadOnly = new Wrapper(impl)
}
