package zio.aws.connectcontactlens.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcontactlens.model.primitives.{
  NextToken,
  MaxResults,
  ContactId,
  InstanceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRealtimeContactAnalysisSegmentsRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest = {
    import ListRealtimeContactAnalysisSegmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest.ReadOnly =
    zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest
      .wrap(buildAwsValue())
}
object ListRealtimeContactAnalysisSegmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest =
      zio.aws.connectcontactlens.model
        .ListRealtimeContactAnalysisSegmentsRequest(
          instanceId,
          contactId,
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def instanceId: InstanceId
    def contactId: ContactId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest
  ) extends zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connectcontactlens.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connectcontactlens.model.primitives.ContactId(impl.contactId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.connectcontactlens.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.connectcontactlens.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest
  ): zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest.ReadOnly =
    new Wrapper(impl)
}
