package zio.aws.connectcontactlens.model
import java.lang.Integer
import zio.aws.connectcontactlens.model.primitives.OffsetMillis
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PointOfInterest(
    beginOffsetMillis: OffsetMillis,
    endOffsetMillis: OffsetMillis
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcontactlens.model.PointOfInterest = {
    import PointOfInterest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcontactlens.model.PointOfInterest
      .builder()
      .beginOffsetMillis(OffsetMillis.unwrap(beginOffsetMillis): Integer)
      .endOffsetMillis(OffsetMillis.unwrap(endOffsetMillis): Integer)
      .build()
  }
  def asReadOnly: zio.aws.connectcontactlens.model.PointOfInterest.ReadOnly =
    zio.aws.connectcontactlens.model.PointOfInterest.wrap(buildAwsValue())
}
object PointOfInterest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcontactlens.model.PointOfInterest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcontactlens.model.PointOfInterest =
      zio.aws.connectcontactlens.model
        .PointOfInterest(beginOffsetMillis, endOffsetMillis)
    def beginOffsetMillis: OffsetMillis
    def endOffsetMillis: OffsetMillis
    def getBeginOffsetMillis: ZIO[Any, Nothing, OffsetMillis] =
      ZIO.succeed(beginOffsetMillis)
    def getEndOffsetMillis: ZIO[Any, Nothing, OffsetMillis] =
      ZIO.succeed(endOffsetMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcontactlens.model.PointOfInterest
  ) extends zio.aws.connectcontactlens.model.PointOfInterest.ReadOnly {
    override val beginOffsetMillis: OffsetMillis =
      zio.aws.connectcontactlens.model.primitives
        .OffsetMillis(impl.beginOffsetMillis())
    override val endOffsetMillis: OffsetMillis =
      zio.aws.connectcontactlens.model.primitives
        .OffsetMillis(impl.endOffsetMillis())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcontactlens.model.PointOfInterest
  ): zio.aws.connectcontactlens.model.PointOfInterest.ReadOnly = new Wrapper(
    impl
  )
}
