package zio.aws.connectcontactlens.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RealtimeContactAnalysisSegment(
    transcript: Optional[zio.aws.connectcontactlens.model.Transcript] =
      Optional.Absent,
    categories: Optional[zio.aws.connectcontactlens.model.Categories] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcontactlens.model.RealtimeContactAnalysisSegment = {
    import RealtimeContactAnalysisSegment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcontactlens.model.RealtimeContactAnalysisSegment
      .builder()
      .optionallyWith(transcript.map(value => value.buildAwsValue()))(
        _.transcript
      )
      .optionallyWith(categories.map(value => value.buildAwsValue()))(
        _.categories
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly =
    zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment
      .wrap(buildAwsValue())
}
object RealtimeContactAnalysisSegment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcontactlens.model.RealtimeContactAnalysisSegment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment =
      zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment(
        transcript.map(value => value.asEditable),
        categories.map(value => value.asEditable)
      )
    def transcript
        : Optional[zio.aws.connectcontactlens.model.Transcript.ReadOnly]
    def categories
        : Optional[zio.aws.connectcontactlens.model.Categories.ReadOnly]
    def getTranscript: ZIO[
      Any,
      AwsError,
      zio.aws.connectcontactlens.model.Transcript.ReadOnly
    ] = AwsError.unwrapOptionField("transcript", transcript)
    def getCategories: ZIO[
      Any,
      AwsError,
      zio.aws.connectcontactlens.model.Categories.ReadOnly
    ] = AwsError.unwrapOptionField("categories", categories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcontactlens.model.RealtimeContactAnalysisSegment
  ) extends zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly {
    override val transcript
        : Optional[zio.aws.connectcontactlens.model.Transcript.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcript())
        .map(value => zio.aws.connectcontactlens.model.Transcript.wrap(value))
    override val categories
        : Optional[zio.aws.connectcontactlens.model.Categories.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.categories())
        .map(value => zio.aws.connectcontactlens.model.Categories.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcontactlens.model.RealtimeContactAnalysisSegment
  ): zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly =
    new Wrapper(impl)
}
