package zio.aws.connectcontactlens.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcontactlens.model.primitives.{
  OffsetMillis,
  TranscriptContent,
  ParticipantRole,
  ParticipantId,
  TranscriptId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Transcript(
    id: TranscriptId,
    participantId: ParticipantId,
    participantRole: ParticipantRole,
    content: TranscriptContent,
    beginOffsetMillis: OffsetMillis,
    endOffsetMillis: OffsetMillis,
    sentiment: zio.aws.connectcontactlens.model.SentimentValue,
    issuesDetected: Optional[
      Iterable[zio.aws.connectcontactlens.model.IssueDetected]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcontactlens.model.Transcript = {
    import Transcript.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcontactlens.model.Transcript
      .builder()
      .id(TranscriptId.unwrap(id): java.lang.String)
      .participantId(ParticipantId.unwrap(participantId): java.lang.String)
      .participantRole(
        ParticipantRole.unwrap(participantRole): java.lang.String
      )
      .content(TranscriptContent.unwrap(content): java.lang.String)
      .beginOffsetMillis(OffsetMillis.unwrap(beginOffsetMillis): Integer)
      .endOffsetMillis(OffsetMillis.unwrap(endOffsetMillis): Integer)
      .sentiment(sentiment.unwrap)
      .optionallyWith(
        issuesDetected.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.issuesDetected)
      .build()
  }
  def asReadOnly: zio.aws.connectcontactlens.model.Transcript.ReadOnly =
    zio.aws.connectcontactlens.model.Transcript.wrap(buildAwsValue())
}
object Transcript {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcontactlens.model.Transcript
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcontactlens.model.Transcript =
      zio.aws.connectcontactlens.model.Transcript(
        id,
        participantId,
        participantRole,
        content,
        beginOffsetMillis,
        endOffsetMillis,
        sentiment,
        issuesDetected.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: TranscriptId
    def participantId: ParticipantId
    def participantRole: ParticipantRole
    def content: TranscriptContent
    def beginOffsetMillis: OffsetMillis
    def endOffsetMillis: OffsetMillis
    def sentiment: zio.aws.connectcontactlens.model.SentimentValue
    def issuesDetected: Optional[
      List[zio.aws.connectcontactlens.model.IssueDetected.ReadOnly]
    ]
    def getId: ZIO[Any, Nothing, TranscriptId] = ZIO.succeed(id)
    def getParticipantId: ZIO[Any, Nothing, ParticipantId] =
      ZIO.succeed(participantId)
    def getParticipantRole: ZIO[Any, Nothing, ParticipantRole] =
      ZIO.succeed(participantRole)
    def getContent: ZIO[Any, Nothing, TranscriptContent] = ZIO.succeed(content)
    def getBeginOffsetMillis: ZIO[Any, Nothing, OffsetMillis] =
      ZIO.succeed(beginOffsetMillis)
    def getEndOffsetMillis: ZIO[Any, Nothing, OffsetMillis] =
      ZIO.succeed(endOffsetMillis)
    def getSentiment
        : ZIO[Any, Nothing, zio.aws.connectcontactlens.model.SentimentValue] =
      ZIO.succeed(sentiment)
    def getIssuesDetected: ZIO[Any, AwsError, List[
      zio.aws.connectcontactlens.model.IssueDetected.ReadOnly
    ]] = AwsError.unwrapOptionField("issuesDetected", issuesDetected)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcontactlens.model.Transcript
  ) extends zio.aws.connectcontactlens.model.Transcript.ReadOnly {
    override val id: TranscriptId =
      zio.aws.connectcontactlens.model.primitives.TranscriptId(impl.id())
    override val participantId: ParticipantId =
      zio.aws.connectcontactlens.model.primitives
        .ParticipantId(impl.participantId())
    override val participantRole: ParticipantRole =
      zio.aws.connectcontactlens.model.primitives
        .ParticipantRole(impl.participantRole())
    override val content: TranscriptContent =
      zio.aws.connectcontactlens.model.primitives
        .TranscriptContent(impl.content())
    override val beginOffsetMillis: OffsetMillis =
      zio.aws.connectcontactlens.model.primitives
        .OffsetMillis(impl.beginOffsetMillis())
    override val endOffsetMillis: OffsetMillis =
      zio.aws.connectcontactlens.model.primitives
        .OffsetMillis(impl.endOffsetMillis())
    override val sentiment: zio.aws.connectcontactlens.model.SentimentValue =
      zio.aws.connectcontactlens.model.SentimentValue.wrap(impl.sentiment())
    override val issuesDetected: Optional[
      List[zio.aws.connectcontactlens.model.IssueDetected.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.issuesDetected())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connectcontactlens.model.IssueDetected.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcontactlens.model.Transcript
  ): zio.aws.connectcontactlens.model.Transcript.ReadOnly = new Wrapper(impl)
}
