package zio.aws.connectcontactlens
import zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest
import software.amazon.awssdk.services.connectcontactlens.ConnectContactLensAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ConnectContactLensMock extends Mock[ConnectContactLens] {
  object ListRealtimeContactAnalysisSegments
      extends Stream[
        ListRealtimeContactAnalysisSegmentsRequest,
        AwsError,
        zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly
      ]
  object ListRealtimeContactAnalysisSegmentsPaginated
      extends Effect[
        ListRealtimeContactAnalysisSegmentsRequest,
        AwsError,
        ReadOnly
      ]
  val compose: URLayer[Proxy, ConnectContactLens] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ConnectContactLens] { rts =>
        zio.ZIO.succeed {
          new ConnectContactLens {
            val api: ConnectContactLensAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ConnectContactLens = this
            def listRealtimeContactAnalysisSegments(
                request: ListRealtimeContactAnalysisSegmentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRealtimeContactAnalysisSegments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRealtimeContactAnalysisSegmentsPaginated(
                request: ListRealtimeContactAnalysisSegmentsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListRealtimeContactAnalysisSegmentsPaginated, request)
          }
        }
      }
    }
  }
}
