package zio.aws.connectcontactlens.model
import java.lang.Integer
import zio.aws.connectcontactlens.model.primitives.CharacterOffset
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CharacterOffsets(
    beginOffsetChar: CharacterOffset,
    endOffsetChar: CharacterOffset
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcontactlens.model.CharacterOffsets = {
    import CharacterOffsets.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcontactlens.model.CharacterOffsets
      .builder()
      .beginOffsetChar(CharacterOffset.unwrap(beginOffsetChar): Integer)
      .endOffsetChar(CharacterOffset.unwrap(endOffsetChar): Integer)
      .build()
  }
  def asReadOnly: zio.aws.connectcontactlens.model.CharacterOffsets.ReadOnly =
    zio.aws.connectcontactlens.model.CharacterOffsets.wrap(buildAwsValue())
}
object CharacterOffsets {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcontactlens.model.CharacterOffsets
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcontactlens.model.CharacterOffsets =
      zio.aws.connectcontactlens.model
        .CharacterOffsets(beginOffsetChar, endOffsetChar)
    def beginOffsetChar: CharacterOffset
    def endOffsetChar: CharacterOffset
    def getBeginOffsetChar: ZIO[Any, Nothing, CharacterOffset] =
      ZIO.succeed(beginOffsetChar)
    def getEndOffsetChar: ZIO[Any, Nothing, CharacterOffset] =
      ZIO.succeed(endOffsetChar)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcontactlens.model.CharacterOffsets
  ) extends zio.aws.connectcontactlens.model.CharacterOffsets.ReadOnly {
    override val beginOffsetChar: CharacterOffset =
      zio.aws.connectcontactlens.model.primitives
        .CharacterOffset(impl.beginOffsetChar())
    override val endOffsetChar: CharacterOffset =
      zio.aws.connectcontactlens.model.primitives
        .CharacterOffset(impl.endOffsetChar())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcontactlens.model.CharacterOffsets
  ): zio.aws.connectcontactlens.model.CharacterOffsets.ReadOnly = new Wrapper(
    impl
  )
}
