package zio.aws.connectcontactlens.model
import zio.aws.connectcontactlens.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRealtimeContactAnalysisSegmentsResponse(
    segments: Iterable[
      zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse = {
    import ListRealtimeContactAnalysisSegmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse
      .builder()
      .segments(segments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse.ReadOnly =
    zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse
      .wrap(buildAwsValue())
}
object ListRealtimeContactAnalysisSegmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse =
      zio.aws.connectcontactlens.model
        .ListRealtimeContactAnalysisSegmentsResponse(
          segments.map { item =>
            item.asEditable
          },
          nextToken.map(value => value)
        )
    def segments: List[
      zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getSegments: ZIO[Any, Nothing, List[
      zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly
    ]] = ZIO.succeed(segments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse
  ) extends zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse.ReadOnly {
    override val segments: List[
      zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment.ReadOnly
    ] = impl
      .segments()
      .asScala
      .map { item =>
        zio.aws.connectcontactlens.model.RealtimeContactAnalysisSegment
          .wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.connectcontactlens.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse
  ): zio.aws.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse.ReadOnly =
    new Wrapper(impl)
}
