package zio.aws.connectcontactlens.model
import scala.jdk.CollectionConverters.*
sealed trait SentimentValue {
  def unwrap
      : software.amazon.awssdk.services.connectcontactlens.model.SentimentValue
}
object SentimentValue {
  def wrap(
      value: software.amazon.awssdk.services.connectcontactlens.model.SentimentValue
  ): zio.aws.connectcontactlens.model.SentimentValue = value match {
    case software.amazon.awssdk.services.connectcontactlens.model.SentimentValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connectcontactlens.model.SentimentValue.POSITIVE =>
      val r = POSITIVE
      r
    case software.amazon.awssdk.services.connectcontactlens.model.SentimentValue.NEUTRAL =>
      val r = NEUTRAL
      r
    case software.amazon.awssdk.services.connectcontactlens.model.SentimentValue.NEGATIVE =>
      val r = NEGATIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connectcontactlens.model.SentimentValue {
    override def unwrap
        : software.amazon.awssdk.services.connectcontactlens.model.SentimentValue =
      software.amazon.awssdk.services.connectcontactlens.model.SentimentValue.UNKNOWN_TO_SDK_VERSION
  }
  case object POSITIVE extends zio.aws.connectcontactlens.model.SentimentValue {
    override def unwrap
        : software.amazon.awssdk.services.connectcontactlens.model.SentimentValue =
      software.amazon.awssdk.services.connectcontactlens.model.SentimentValue.POSITIVE
  }
  case object NEUTRAL extends zio.aws.connectcontactlens.model.SentimentValue {
    override def unwrap
        : software.amazon.awssdk.services.connectcontactlens.model.SentimentValue =
      software.amazon.awssdk.services.connectcontactlens.model.SentimentValue.NEUTRAL
  }
  case object NEGATIVE extends zio.aws.connectcontactlens.model.SentimentValue {
    override def unwrap
        : software.amazon.awssdk.services.connectcontactlens.model.SentimentValue =
      software.amazon.awssdk.services.connectcontactlens.model.SentimentValue.NEGATIVE
  }
}
