package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.KeySchemaAttributeName
import scala.jdk.CollectionConverters.*
final case class AttributeDefinition(
    attributeName: KeySchemaAttributeName,
    attributeType: zio.aws.dynamodb.model.ScalarAttributeType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AttributeDefinition = {
    import AttributeDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AttributeDefinition
      .builder()
      .attributeName(
        KeySchemaAttributeName.unwrap(attributeName): java.lang.String
      )
      .attributeType(attributeType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.AttributeDefinition.ReadOnly =
    zio.aws.dynamodb.model.AttributeDefinition.wrap(buildAwsValue())
}
object AttributeDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AttributeDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.AttributeDefinition =
      zio.aws.dynamodb.model.AttributeDefinition(attributeName, attributeType)
    def attributeName: KeySchemaAttributeName
    def attributeType: zio.aws.dynamodb.model.ScalarAttributeType
    def getAttributeName: ZIO[Any, Nothing, KeySchemaAttributeName] =
      ZIO.succeed(attributeName)
    def getAttributeType
        : ZIO[Any, Nothing, zio.aws.dynamodb.model.ScalarAttributeType] =
      ZIO.succeed(attributeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AttributeDefinition
  ) extends zio.aws.dynamodb.model.AttributeDefinition.ReadOnly {
    override val attributeName: KeySchemaAttributeName =
      zio.aws.dynamodb.model.primitives
        .KeySchemaAttributeName(impl.attributeName())
    override val attributeType: zio.aws.dynamodb.model.ScalarAttributeType =
      zio.aws.dynamodb.model.ScalarAttributeType.wrap(impl.attributeType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AttributeDefinition
  ): zio.aws.dynamodb.model.AttributeDefinition.ReadOnly = new Wrapper(impl)
}
