package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait ComparisonOperator {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ComparisonOperator
  ): zio.aws.dynamodb.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.EQ =>
      val r = EQ
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.NE =>
      val r = NE
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.IN =>
      val r = IN
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.LE =>
      val r = LE
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.LT =>
      val r = LT
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.GE =>
      val r = GE
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.GT =>
      val r = GT
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.BETWEEN =>
      val r = BETWEEN
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.NOT_NULL =>
      val r = NOT_NULL
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.NULL =>
      val r = NULL
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.CONTAINS =>
      val r = CONTAINS
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.NOT_CONTAINS =>
      val r = NOT_CONTAINS
      r
    case software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.BEGINS_WITH =>
      val r = BEGINS_WITH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQ extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.EQ
  }
  case object NE extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.NE
  }
  case object IN extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.IN
  }
  case object LE extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.LE
  }
  case object LT extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.LT
  }
  case object GE extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.GE
  }
  case object GT extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.GT
  }
  case object BETWEEN extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.BETWEEN
  }
  case object NOT_NULL extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.NOT_NULL
  }
  case object NULL extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.NULL
  }
  case object CONTAINS extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.CONTAINS
  }
  case object NOT_CONTAINS extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.NOT_CONTAINS
  }
  case object BEGINS_WITH extends zio.aws.dynamodb.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ComparisonOperator =
      software.amazon.awssdk.services.dynamodb.model.ComparisonOperator.BEGINS_WITH
  }
}
